/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.payment.stripe.event.BaseStripeEvent;
import inc.yukawa.chain.base.payment.stripe.event.DefaultStripeEventMapper;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventHandler;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventHandlerDelegator;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventHandlerDelegatorImpl;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventMapper;
import inc.yukawa.chain.base.payment.stripe.service.StripeHookService;
import inc.yukawa.chain.base.payment.stripe.service.StripeHookServiceImpl;
import java.util.List;
import org.springframework.context.annotation.Bean;

public class StripeHookConfigBase {
    private final String webHookSecretKey;

    public StripeHookConfigBase(String webHookSecretKey) {
        this.webHookSecretKey = webHookSecretKey;
    }

    @Bean
    public StripeEventHandlerDelegator eventHandlerDelegator(List<StripeEventHandler<? extends BaseStripeEvent>> handlers) {
        return new StripeEventHandlerDelegatorImpl(handlers);
    }

    @Bean
    public StripeEventMapper eventMapper() {
        return new DefaultStripeEventMapper();
    }

    @Bean
    public StripeHookService stripeHookService(ObjectMapper mapper, StripeEventHandlerDelegator stripeEventHandlerDelegator, StripeEventMapper stripeEventMapper) {
        return new StripeHookServiceImpl(this.webHookSecretKey, mapper, stripeEventHandlerDelegator, stripeEventMapper);
    }
}

