/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.event;

import inc.yukawa.chain.base.payment.stripe.event.BaseStripeEvent;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventHandler;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventHandlerDelegator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StripeEventHandlerDelegatorImpl
implements StripeEventHandlerDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(StripeEventHandlerDelegatorImpl.class);
    private final List<StripeEventHandler<? extends BaseStripeEvent>> handlers;

    public StripeEventHandlerDelegatorImpl(List<StripeEventHandler<? extends BaseStripeEvent>> handlers) {
        this.handlers = handlers;
        this.logHandlers(handlers);
    }

    private void logHandlers(List<StripeEventHandler<? extends BaseStripeEvent>> handlers) {
        String handlerClassNames = handlers.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", "));
        LOG.info("[{}] Found {} stripe event handlers: {}", new Object[]{this.getClass().getSimpleName(), handlers.size(), handlerClassNames});
    }

    @Override
    public <T extends BaseStripeEvent> Mono<Void> handleEvent(T event) {
        return Flux.fromIterable(this.handlers).filter(handler -> this.isHandlerCompatibleWithEvent((StripeEventHandler<? extends BaseStripeEvent>)handler, event)).map(handler -> handler).flatMap(handler -> handler.handle(event)).then();
    }

    private <T extends BaseStripeEvent> boolean isHandlerCompatibleWithEvent(StripeEventHandler<? extends BaseStripeEvent> handler, T event) {
        return handler.getEventClass().isAssignableFrom(event.getClass());
    }
}

