/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.rest;

import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentMethods;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.StripeAccount;
import inc.yukawa.chain.base.payment.stripe.domain.StripeCustomer;
import inc.yukawa.chain.base.payment.stripe.service.AuthenticatedReactiveStripeService;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Mono;

public class StripeRestBase<PR extends PaymentIntentRequest, PRE extends PaymentIntentResponse, SR extends SetupIntentRequest, SRE extends SetupIntentResponse, SC extends StripeCustomer> {
    private final AuthenticatedReactiveStripeService<PR, PRE, SR, SRE, SC> stripeService;

    public StripeRestBase(AuthenticatedReactiveStripeService<PR, PRE, SR, SRE, SC> stripeService) {
        this.stripeService = stripeService;
    }

    @PostMapping(value={"/setup-intent"})
    public Mono<SRE> createSetupIntent(@RequestBody SR setupIntentRequest) {
        return this.stripeService.createSetupIntent(setupIntentRequest);
    }

    @PostMapping(value={"/payment-intent"})
    public Mono<PRE> createPaymentIntent(@RequestBody PR paymentIntentRequest) {
        return this.stripeService.createPaymentIntent(paymentIntentRequest);
    }

    @GetMapping(value={"/payment-methods"})
    public Mono<PaymentMethods> getPaymentMethodsForAuthUser() {
        return this.stripeService.getPaymentMethodsForAuthenticatedUser();
    }

    @DeleteMapping(value={"/payment-methods/{paymentMethodId}"})
    public Mono<Void> deletePaymentMethod(@PathVariable String paymentMethodId) {
        return this.stripeService.deletePaymentMethod(paymentMethodId);
    }

    @GetMapping(value={"/connected-accounts"})
    public Mono<List<StripeAccount>> getConnectedAccounts() {
        return this.stripeService.getConnectedAccounts();
    }
}

