/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stripe.model.Event;
import com.stripe.net.Webhook;
import inc.yukawa.chain.base.payment.stripe.event.BaseStripeEvent;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventHandlerDelegator;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventMapper;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventPayload;
import inc.yukawa.chain.base.payment.stripe.service.StripeHookService;
import reactor.core.publisher.Mono;

public class StripeHookServiceImpl
implements StripeHookService {
    private final String endpointSecret;
    private final ObjectMapper objectMapper;
    private final StripeEventHandlerDelegator stripeEventHandlerDelegator;
    private final StripeEventMapper stripeEventMapper;

    public StripeHookServiceImpl(String endpointSecret, ObjectMapper mapper, StripeEventHandlerDelegator stripeEventHandlerDelegator, StripeEventMapper stripeEventMapper) {
        this.endpointSecret = endpointSecret;
        this.objectMapper = mapper;
        this.stripeEventHandlerDelegator = stripeEventHandlerDelegator;
        this.stripeEventMapper = stripeEventMapper;
    }

    @Override
    public Mono<Void> handle(String payload, String sigHeader) {
        return this.toEvent(payload, sigHeader).flatMap(this.stripeEventHandlerDelegator::handleEvent);
    }

    private Mono<BaseStripeEvent> toEvent(String payload, String sigHeader) {
        return this.createStripeEvent(payload, sigHeader).flatMap(this::createBaseStripeEvent);
    }

    private Mono<Event> createStripeEvent(String payload, String sigHeader) {
        return Mono.fromCallable(() -> Webhook.constructEvent((String)payload, (String)sigHeader, (String)this.endpointSecret));
    }

    private Mono<BaseStripeEvent> createBaseStripeEvent(Event event) {
        return this.extractEventPayloadMono(event).flatMap(this.stripeEventMapper::getEvent);
    }

    private StripeEventPayload extractEventPayload(Event event) throws JsonProcessingException {
        return (StripeEventPayload)this.objectMapper.readValue(event.toJson(), StripeEventPayload.class);
    }

    private Mono<StripeEventPayload> extractEventPayloadMono(Event event) {
        return Mono.fromCallable(() -> this.extractEventPayload(event));
    }
}

