/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.client;

import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.AccountCollection;
import com.stripe.model.Customer;
import com.stripe.model.CustomerSearchResult;
import com.stripe.model.PaymentIntent;
import com.stripe.model.PaymentMethod;
import com.stripe.model.Refund;
import com.stripe.model.SetupIntent;
import com.stripe.model.Transfer;
import com.stripe.net.RequestOptions;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.CustomerListPaymentMethodsParams;
import com.stripe.param.CustomerSearchParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.RefundCreateParams;
import com.stripe.param.SetupIntentCreateParams;
import com.stripe.param.TransferCreateParams;
import inc.yukawa.chain.base.payment.stripe.client.StripeClient;
import inc.yukawa.chain.base.payment.stripe.client.StripeLibraryRequestMapper;
import inc.yukawa.chain.base.payment.stripe.client.StripeLibraryResponseMapper;
import inc.yukawa.chain.base.payment.stripe.client.StripeSupplier;
import inc.yukawa.chain.base.payment.stripe.client.Utils;
import inc.yukawa.chain.base.payment.stripe.domain.CardPaymentMethod;
import inc.yukawa.chain.base.payment.stripe.domain.CreateTransferRequest;
import inc.yukawa.chain.base.payment.stripe.domain.CreateTransferResponse;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentMethods;
import inc.yukawa.chain.base.payment.stripe.domain.RefundRequest;
import inc.yukawa.chain.base.payment.stripe.domain.RefundResponse;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.StripeAccount;
import inc.yukawa.chain.base.payment.stripe.domain.StripeCustomer;
import inc.yukawa.chain.base.payment.stripe.exception.BaseStripeException;
import inc.yukawa.chain.base.payment.stripe.exception.MultipleCustomersFoundException;
import inc.yukawa.chain.base.payment.stripe.exception.StripeCustomerNotFoundException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StripeLibraryClient<PR extends PaymentIntentRequest, PRE extends PaymentIntentResponse, SR extends SetupIntentRequest, SRE extends SetupIntentResponse, SC extends StripeCustomer>
implements StripeClient<PR, PRE, SR, SRE, SC> {
    private final StripeLibraryResponseMapper<PRE, SRE, SC> responseMapper;
    private final StripeLibraryRequestMapper<PR, SR> requestMapper;

    public StripeLibraryClient(StripeLibraryResponseMapper<PRE, SRE, SC> responseMapper, StripeLibraryRequestMapper<PR, SR> requestMapper) {
        this.responseMapper = responseMapper;
        this.requestMapper = requestMapper;
    }

    @Override
    public PRE createPaymentIntent(PR paymentIntentRequest) throws BaseStripeException {
        PaymentIntentCreateParams.Builder paramsBuilder = this.requestMapper.mapPaymentIntentRequest(paymentIntentRequest);
        Map<String, String> metadata = Utils.extractMetaDataFromObject(paymentIntentRequest);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            paramsBuilder.putMetadata(entry.getKey(), entry.getValue());
        }
        PaymentIntentCreateParams params = paramsBuilder.build();
        PaymentIntent response = this.handleStripeException(() -> PaymentIntent.create((PaymentIntentCreateParams)params));
        return this.responseMapper.mapPaymentIntentResponse(response);
    }

    @Override
    public SRE createSetupIntent(SR setupIntentRequest) throws BaseStripeException {
        SetupIntentCreateParams.Builder paramsBuilder = this.requestMapper.mapSetupIntentRequest(setupIntentRequest);
        Map<String, String> metadata = Utils.extractMetaDataFromObject(setupIntentRequest);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            paramsBuilder.putMetadata(entry.getKey(), entry.getValue());
        }
        SetupIntent response = this.handleStripeException(() -> SetupIntent.create((Map)paramsBuilder.build().toMap()));
        return this.responseMapper.mapSetupIntentResponse(response);
    }

    @Override
    public PaymentMethods getPaymentMethods(String stripeUserId) throws BaseStripeException {
        Customer customer = this.handleStripeException(() -> Customer.retrieve((String)stripeUserId));
        CustomerListPaymentMethodsParams params = CustomerListPaymentMethodsParams.builder().setType(CustomerListPaymentMethodsParams.Type.CARD).build();
        List paymentMethodCollection = this.handleStripeException(() -> customer.listPaymentMethods(params).getData());
        List<CardPaymentMethod> cardPaymentMethods = paymentMethodCollection.stream().map(StripeLibraryClient::toCardPaymentMethod).collect(Collectors.toList());
        PaymentMethods result = new PaymentMethods();
        result.setCardPaymentMethods(cardPaymentMethods);
        return result;
    }

    private static CardPaymentMethod toCardPaymentMethod(PaymentMethod paymentMethod) {
        PaymentMethod.Card card = paymentMethod.getCard();
        return ((CardPaymentMethod.CardPaymentMethodBuilder)((CardPaymentMethod.CardPaymentMethodBuilder)((CardPaymentMethod.CardPaymentMethodBuilder)((CardPaymentMethod.CardPaymentMethodBuilder)((CardPaymentMethod.CardPaymentMethodBuilder)CardPaymentMethod.builder().paymentMethodId(paymentMethod.getId())).expiryMonth(card.getExpMonth().toString())).expiryYear(card.getExpYear().toString())).brand(card.getBrand())).lastDigits(card.getLast4())).build();
    }

    @Override
    public void deletePaymentMethod(String paymentMethodId) throws BaseStripeException {
        this.handleStripeException(() -> PaymentMethod.retrieve((String)paymentMethodId).detach());
    }

    @Override
    public SC createCustomer(String userName) throws BaseStripeException {
        CustomerCreateParams params = CustomerCreateParams.builder().putMetadata("userId", userName).setName(userName).build();
        Customer customer = this.handleStripeException(() -> Customer.create((Map)params.toMap()));
        return this.responseMapper.mapStripeCustomer(customer);
    }

    @Override
    public SC getCustomerById(String stripeUserId) throws BaseStripeException {
        Customer customer = this.handleStripeException(() -> Customer.retrieve((String)stripeUserId));
        return this.responseMapper.mapStripeCustomer(customer);
    }

    @Override
    public SC getCustomerByName(String userName) throws BaseStripeException {
        CustomerSearchParams searchParams = CustomerSearchParams.builder().setQuery(String.format("name:'%s'", userName)).build();
        CustomerSearchResult result = this.handleStripeException(() -> Customer.search((Map)searchParams.toMap()));
        List customers = result.getData();
        if (customers.size() == 1) {
            return this.responseMapper.mapStripeCustomer((Customer)customers.get(0));
        }
        if (customers.size() == 0) {
            throw new StripeCustomerNotFoundException(userName);
        }
        throw new MultipleCustomersFoundException(userName);
    }

    @Override
    public List<StripeAccount> getConnectedAccounts() throws BaseStripeException {
        HashMap<String, Integer> accountParams = new HashMap<String, Integer>();
        accountParams.put("limit", 100);
        AccountCollection accountCollection = this.handleStripeException(() -> Account.list((Map)accountParams));
        return accountCollection.getData().stream().map(StripeAccount::new).collect(Collectors.toList());
    }

    @Override
    public CreateTransferResponse createTransfer(CreateTransferRequest request) throws BaseStripeException {
        TransferCreateParams.Builder builder = TransferCreateParams.builder();
        builder.setAmount(Long.valueOf(request.getAmount().longValue())).setCurrency("EUR").setDescription(request.getDescription()).setTransferGroup(request.getTransferGroup()).setSourceTransaction(request.getSourceTransaction()).setDestination(request.getDestinationAccountId());
        Transfer res = this.handleStripeException(() -> Transfer.create((TransferCreateParams)builder.build()));
        CreateTransferResponse response = new CreateTransferResponse();
        response.setDestinationAccountId(res.getDestination());
        response.setAmount(BigInteger.valueOf(res.getAmount()));
        return response;
    }

    @Override
    public RefundResponse createRefund(RefundRequest request) throws BaseStripeException {
        RefundCreateParams.Builder builder = RefundCreateParams.builder();
        builder.setAmount(Long.valueOf(request.getAmount().longValue())).setCharge(request.getCharge()).setMetadata(request.getMetaData());
        Refund res = this.handleStripeException(() -> Refund.create((RefundCreateParams)builder.build()));
        RefundResponse response = new RefundResponse();
        response.setCharge(res.getCharge());
        response.setAmount(BigInteger.valueOf(res.getAmount()));
        return response;
    }

    @Override
    public CreateTransferResponse createRefundTransfer(CreateTransferRequest request, String stripeAccountId) throws BaseStripeException {
        TransferCreateParams.Builder builder = TransferCreateParams.builder();
        builder.setAmount(Long.valueOf(request.getAmount().longValue())).setCurrency("EUR").setDescription(request.getDescription()).setDestination(request.getDestinationAccountId());
        RequestOptions requestOptions = RequestOptions.builder().setStripeAccount(stripeAccountId).build();
        Transfer res = this.handleStripeException(() -> Transfer.create((TransferCreateParams)builder.build(), (RequestOptions)requestOptions));
        CreateTransferResponse response = new CreateTransferResponse();
        response.setDestinationAccountId(res.getDestination());
        response.setAmount(BigInteger.valueOf(res.getAmount()));
        return response;
    }

    private <T> T handleStripeException(StripeSupplier<T> function) throws BaseStripeException {
        try {
            return function.get();
        }
        catch (StripeException e) {
            throw new BaseStripeException(e);
        }
    }
}

