/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.event;

import inc.yukawa.chain.base.payment.stripe.event.StripeEventPayload;
import inc.yukawa.chain.base.payment.stripe.exception.StripeCustomerIdNotFoundException;
import java.util.Map;

public interface BaseStripeEvent {
    public String getValue();

    public StripeEventPayload getPayload();

    default public Map<String, String> getMetadata() {
        Map<String, Object> object = this.getObject();
        return (Map)object.get("metadata");
    }

    default public Map<String, Object> getObject() {
        return (Map)this.getPayload().getData().get("object");
    }

    default public String getStripeCustomerId() throws StripeCustomerIdNotFoundException {
        String stripeCustomerId = (String)this.getObject().get("customer");
        if (stripeCustomerId == null) {
            throw new StripeCustomerIdNotFoundException("This stripe object has no customerId set", this.getValue());
        }
        return stripeCustomerId;
    }

    public static interface Factory {
        public BaseStripeEvent create(String var1, StripeEventPayload var2);
    }
}

