/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.rest.ctrl;

import inc.yukawa.chain.base.core.domain.entity.EntityFilter;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.service.RepoAspect;
import io.swagger.v3.oas.annotations.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Mono;

public interface BaseReadRepoRest<K, V extends Keyed<K>, F extends EntityFilter> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"RestAspect");

    public RepoAspect<K, V, F> getAspect();

    @GetMapping(value={"/"})
    @Operation(summary="load")
    default public Mono<V> load(@RequestParam(value="key") K key) {
        LOG.info("[{}] load: {}", (Object)this.getClass().getSimpleName(), key);
        return this.getAspect().load(key);
    }

    @PostMapping(value={"/query"})
    @Operation(summary="query")
    default public Mono<QueryResult<V>> query(@RequestBody F filter) {
        LOG.info("[{}] query: {}", (Object)this.getClass().getSimpleName(), filter);
        return this.getAspect().query(filter);
    }
}

