/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.rest.config;

import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.UriComponentsBuilder;

@SecurityScheme(name="security_auth", type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(password=@OAuthFlow(tokenUrl="${chain.security.login.form:/api/security-service/oauth/token}", refreshUrl="${chain.security.login.refresh:/api/security-service/oauth/refresh}")))
public class OpenApiConfigBase {
    public static final String SECURITY_SCHEME_NAME = "security_auth";
    @Value(value="${release.build.version:-}")
    protected String version;
    @Value(value="${spring.application.name:app}")
    protected String applicationName;
    @Value(value="${external.schemes:https}")
    protected String scheme;
    @Value(value="${external.host:localhost}")
    protected String host;
    @Value(value="${external.port:-1}")
    protected Integer port;
    @Value(value="${external.path:}")
    protected String path;

    public OpenAPI baseOpenAPI() {
        return new OpenAPI().info(new Info().title(this.applicationName).contact(new Contact().name("Yukawa Systems").email("info@yukawa.de").url("https://www.yukawa.de")).description(String.format("%s (%s)", this.version, new Date()))).servers(this.servers()).addSecurityItem(new SecurityRequirement().addList(SECURITY_SCHEME_NAME));
    }

    protected List<Server> servers() {
        Server server = new Server();
        server.setUrl(this.externalServerUrl());
        return List.of(server);
    }

    protected String externalServerUrl() {
        return UriComponentsBuilder.newInstance().scheme(this.scheme).host(this.host).port(this.port > 0 ? this.port : -1).path(this.path).build().toUriString();
    }
}

