/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.rest.ctrl;

import inc.yukawa.chain.base.core.domain.entity.EntityFilter;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.service.RepoAspect;
import io.swagger.v3.oas.annotations.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Mono;

public interface BaseWriteRepoRest<K, V extends Keyed<K>, F extends EntityFilter> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"RestAspect");

    public RepoAspect<K, V, F> getAspect();

    @PostMapping(value={"/put"})
    @Operation(summary="put")
    default public Mono<V> put(@RequestBody V entity) {
        LOG.info("[{}] put: {}", (Object)this.getClass().getSimpleName(), entity);
        return this.getAspect().put(entity);
    }

    @PostMapping(value={"/create"})
    @Operation(summary="create")
    default public Mono<V> create(@RequestBody V entity) {
        LOG.info("[{}] create: {}", (Object)this.getClass().getSimpleName(), entity);
        return this.getAspect().create(entity);
    }

    @PostMapping(value={"/update"})
    @Operation(summary="update")
    default public Mono<V> update(@RequestBody V entity) {
        LOG.info("[{}] update: {}", (Object)this.getClass().getSimpleName(), entity);
        return this.getAspect().update(entity);
    }

    @PostMapping(value={"/merge"})
    @Operation(summary="merge")
    default public Mono<V> merge(@RequestBody V entity) {
        LOG.info("[{}] merge: {}", (Object)this.getClass().getSimpleName(), entity);
        return this.getAspect().merge(entity);
    }

    @DeleteMapping(value={"/"})
    @Operation(summary="deleteByKey")
    default public Mono<V> deleteByKey(@RequestParam(value="key") K key) {
        LOG.info("[{}] deleteByKey: {}", (Object)this.getClass().getSimpleName(), key);
        return this.getAspect().deleteByKey(key);
    }
}

