/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.service;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import inc.yukawa.chain.base.service.RepoAspect;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RepoAspectBase<K, V extends Keyed<K>, F>
implements RepoAspect<K, V, F> {
    protected CrudRepository<K, V, F> repo;
    protected Consumer<V> keyAssigner;

    public RepoAspectBase(CrudRepository<K, V, F> repo) {
        this.repo = repo;
    }

    public RepoAspectBase(CrudRepository<K, V, F> repo, Consumer<V> keyAssigner) {
        this.repo = repo;
        this.keyAssigner = keyAssigner;
    }

    @Override
    public Mono<V> load(K key) {
        return this.repo.load(key);
    }

    @Override
    public Mono<Long> count(F filter) {
        return this.repo.count(filter);
    }

    @Override
    public Flux<V> find(F filter) {
        return this.repo.find(filter);
    }

    @Override
    public Flux<K> findKeys(F filter) {
        return this.repo.findKeys(filter);
    }

    @Override
    public Mono<QueryResult<V>> query(F filter) {
        return this.repo.query(filter);
    }

    @Override
    public Mono<V> read(F filter) {
        return this.repo.read(filter);
    }

    @Override
    public Mono<V> create(V entity) {
        if (this.keyAssigner != null && entity.key() == null) {
            this.keyAssigner.accept(entity);
        }
        return this.repo.create(entity);
    }

    @Override
    public Mono<V> put(V entity) {
        return this.repo.put(entity);
    }

    @Override
    public Mono<V> update(V entity) {
        return this.repo.update(entity);
    }

    @Override
    public Mono<V> merge(V entity) {
        return this.repo.merge(entity);
    }

    @Override
    public Mono<V> delete(V entity) {
        return this.repo.delete(entity);
    }

    @Override
    public Mono<V> deleteByKey(K key) {
        return this.repo.deleteByKey(key);
    }
}

