/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.service.excel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public abstract class ExcelConverterBase {
    private static final Logger log = LoggerFactory.getLogger(ExcelConverterBase.class);
    @Value(value="${material.report.excel.template:#{null}}")
    private String template;
    @Value(value="${material.report.excel.rowsOffset:0}")
    private int rowsOffset;

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> byte[] toExcel(List<T> objects, List<String> columns, List<String> headers) {
        try (XSSFWorkbook workbook = this.createWorkbook();){
            Object object;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                XSSFSheet sheet = workbook.createSheet();
                int rowCount = this.rowsOffset;
                XSSFRow headerRow = sheet.createRow(rowCount++);
                if (headers != null && !headers.isEmpty()) {
                    headers.forEach(arg_0 -> ExcelConverterBase.lambda$toExcel$0((Row)headerRow, headers, arg_0));
                }
                for (T object2 : objects) {
                    XSSFRow row = sheet.createRow(rowCount++);
                    for (String column : columns) {
                        this.createCell((Row)row, object2, column, columns.indexOf(column));
                    }
                }
                workbook.write((OutputStream)bos);
                object = bos.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected <T> void createCell(Row row, T p, String columnName, int columnPosition) {
        String res = "";
        try {
            Object value = PropertyUtils.getProperty(p, (String)columnName);
            res = value == null ? "" : (value.getClass().isArray() ? StringUtils.arrayToCommaDelimitedString((Object[])((Object[])value)) : (value instanceof Collection ? StringUtils.collectionToCommaDelimitedString((Collection)((Collection)value)) : String.valueOf(value)));
        }
        catch (Throwable e) {
            log.error("{} while reading attribute '{}' from project with id {}: {}", new Object[]{e.getClass().getSimpleName(), columnName, p, e.getMessage()});
        }
        row.createCell(columnPosition).setCellValue(res);
    }

    protected XSSFWorkbook createWorkbook() {
        if (this.template == null) {
            return new XSSFWorkbook();
        }
        try {
            InputStream templateFis = this.getClass().getResourceAsStream(this.template);
            return new XSSFWorkbook(templateFis);
        }
        catch (IOException e) {
            log.warn("Error while opening template: {}. Returning an empty sheet instead.", (Object)e.getMessage());
            return new XSSFWorkbook();
        }
    }

    private static /* synthetic */ void lambda$toExcel$0(Row headerRow, List headers, String s) {
        headerRow.createCell(headers.indexOf(s)).setCellValue(s);
    }
}

