/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.client;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.service.RepoAspect;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RepoRestClient<K, V extends Keyed<K>, F>
implements RepoAspect<K, V, F> {
    protected final ParameterizedTypeReference<K> keyType;
    protected final ParameterizedTypeReference<V> valueType;
    protected final ParameterizedTypeReference<F> filterType;
    protected final ParameterizedTypeReference<QueryResult<V>> queryType;
    protected final WebClient delegator;

    public RepoRestClient(WebClient client) {
        this.delegator = client;
        this.keyType = ParameterizedTypeReference.forType((Type)ResolvableType.forInstance((Object)this).as(RepoRestClient.class).getGeneric(new int[]{0}).getType());
        this.valueType = ParameterizedTypeReference.forType((Type)ResolvableType.forInstance((Object)this).as(RepoRestClient.class).getGeneric(new int[]{1}).getType());
        this.filterType = ParameterizedTypeReference.forType((Type)ResolvableType.forInstance((Object)this).as(RepoRestClient.class).getGeneric(new int[]{2}).getType());
        this.queryType = ParameterizedTypeReference.forType((Type)ResolvableType.forClassWithGenerics(QueryResult.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType(this.valueType)}).getType());
    }

    @Override
    public Mono<V> load(@NotNull K key) {
        return this.delegator.get().uri(uriBuilder -> uriBuilder.path("/").queryParam("key", new Object[]{key}).build(new Object[0])).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Mono<Long> count(@NotNull @Valid F filter) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/count", new Object[0])).body((Publisher)Mono.just(filter), this.filterType).retrieve().bodyToMono(Long.class);
    }

    @Override
    public Flux<V> find(@NotNull @Valid F filter) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/find", new Object[0])).body((Publisher)Mono.just(filter), this.filterType).retrieve().bodyToFlux(this.valueType);
    }

    @Override
    public Flux<K> findKeys(@NotNull @Valid F filter) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/findKeys", new Object[0])).body((Publisher)Mono.just(filter), this.filterType).retrieve().bodyToFlux(this.keyType);
    }

    @Override
    public Mono<QueryResult<V>> query(@NotNull @Valid F filter) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/query", new Object[0])).body((Publisher)Mono.just(filter), this.filterType).retrieve().bodyToMono(this.queryType);
    }

    @Override
    public Mono<V> put(@NotNull @Valid V entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/put", new Object[0])).body((Publisher)Mono.just(entity), this.valueType).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Mono<V> create(@NotNull @Valid V entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/create", new Object[0])).body((Publisher)Mono.just(entity), this.valueType).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Mono<V> update(@NotNull @Valid V entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/update", new Object[0])).body((Publisher)Mono.just(entity), this.valueType).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Mono<V> merge(@NotNull V entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/merge", new Object[0])).body((Publisher)Mono.just(entity), this.valueType).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Mono<V> deleteByKey(@NotBlank K key) {
        return this.delegator.delete().uri(uriBuilder -> uriBuilder.path("/").queryParam("key", new Object[]{key}).build(new Object[0])).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Mono<V> delete(@NotNull V entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/delete", new Object[0])).body((Publisher)Mono.just(entity), this.valueType).retrieve().bodyToMono(this.valueType);
    }

    @Override
    public Flux<V> deleteAll(@NotNull @Valid F filter) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/deleteAll", new Object[0])).body((Publisher)Mono.just(filter), this.filterType).retrieve().bodyToFlux(this.valueType);
    }
}

