/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.service;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import reactor.core.publisher.Mono;

public abstract class AspectServiceBase {
    private static final Logger log = LoggerFactory.getLogger(AspectServiceBase.class);

    protected <T> Mono<EditResult> asEdit(String op, Mono<T> response, String key) {
        return response.map(r -> new EditResult(op, r.getClass(), key)).onErrorResume(e -> e instanceof DataAccessException, e -> {
            log.info("{} failed for '{}', reason: {}: '{}'", new Object[]{op, key, e.getClass().getSimpleName(), e.getMessage()});
            return Mono.just((Object)new EditResult(op, e.getClass(), key, ResultDetail.error((Throwable)e)));
        }).doOnError(e -> log.error(op + " failed: " + e.getMessage(), e));
    }
}

