package chain.base.test.domain;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import java.io.StringWriter;

/**
 * @author wilko.wilde
 * @since 07.04.2018
 */
@SuppressWarnings("unused")
public abstract class AbstractDomainTest {

    protected Boolean formattedOutput = true;
    //protected boolean outputFormatted = true;
    //protected boolean jsonFormatted = outputFormatted;
    //protected boolean xmlFormatted = outputFormatted;

    // @toDo [ww] implement common domain test
    // - check serialisation
    // - check validation

    protected boolean writeOutput(String type){
        return false;
    }

    protected boolean formatOutput(String type){
        return true;
    }

    protected String toXml(Object expected) throws JAXBException {
        final JAXBContext context = JAXBContext.newInstance(expected.getClass());
        final Marshaller marshaller = context.createMarshaller();
        if(formattedOutput != null)
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, formattedOutput);
        final StringWriter sw = new StringWriter();
        marshaller.marshal(expected, sw);
        return sw.toString();
    }

}
