package chain.base.test.security;

import chain.code.ChainRealm;
import chain.error.AuthorizationError;
import chain.security.ChainFinalPrincipal;
import chain.security.ChainPrincipal;
import chain.security.atomic.ChainSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import static org.fest.assertions.Assertions.assertThat;

/**
 * @author wilko.wilde
 * @since 13.02.2019
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public abstract class AbstractSecurityTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractSecurityTest.class);

    @Autowired(required = false)
    protected ChainSecurity chainSecurity;
    
    // @toDo [ww] move to chain-base-mod

    protected ChainPrincipal noUser = null;

    protected ChainPrincipal authUser = new ChainFinalPrincipal(4711L, "authUser") {
        @Override
        public boolean inRole(String name) {
            return ChainRealm.ROLE_AUTH.equals(name);
        }
    };

    protected boolean checkAccess(String req, ChainPrincipal principal, Boolean expected) {
        return checkAccess(req, principal, expected, null);
    }

    @SuppressWarnings("SameParameterValue")
    protected boolean checkAccess(String req, ChainPrincipal principal, Boolean expected, Object[] paras) {
        boolean allowed = false;
        try {
            chainSecurity.checkCall(req, paras, principal);
            allowed = true;
        } catch (AuthorizationError authorizationError) {
            // this is a check
        }
        log.debug("req {} {} => {}", req, principal, allowed);
        if(expected != null)
            assertThat(allowed)
                    .describedAs(req + " "+principal).isEqualTo(expected);
        return allowed;
    }
}
