package chain.base.test.util;

/*Generated by MPS */

import inc.chaos.jdbc.script.SqlRunner;
import java.io.InputStream;
import java.sql.Connection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.sql.Statement;
import inc.chaos.jdbc.JdbcFunctions;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class SqlScriptRunnerChain implements SqlRunner {
  private String separator;

  public SqlScriptRunnerChain() {
    this.separator = ";";
    this.setExecute(true);
    this.setPrint(true);
  }

  public void runScript(InputStream stream, Connection conn) throws IOException, SQLException {
    assert stream != null;
    assert conn != null;
    List<String> statements = new ArrayList<String>();
    this.parseStatements(stream, statements);
    System.out.println("--------------------------------------------------------------------------------------");
    System.out.println(((!(this.getExecute()) ?
      "Printed " :
      "Executed "
    )) + statements.size() + " statements");
    Statement stmt = null;
    try {
      stmt = conn.createStatement();
      for (String sql : statements) {
        try {
          if (this.getPrint()) {
            System.out.println(sql);
          }
          if (this.getExecute()) {
            stmt.execute(sql);
          }
        } catch (Exception sqlEx) {
          if (!(sql.startsWith("DROP")) && !(sql.startsWith("drop"))) {
            System.err.println("ERROR: " + sqlEx.getMessage() + "\nSQL:" + sql);
            sqlEx.printStackTrace();
          }
        } finally {
        }
      }
    } finally {
      JdbcFunctions.close(stmt);
    }
    System.out.println(((!(this.getExecute()) ?
      "Printed " :
      "Executed "
    )) + statements.size() + " statements");
  }

  private void parseStatements(InputStream stream, List<String> statements) throws IOException {
    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
    StringBuilder buff = new StringBuilder();
    String read;
    do {
      read = reader.readLine();
      if (read != null) {
        read = StringUtils.stripEnd(read, " \n\r\t");
        if (read.length() > 0) {
          if (read.contains(separator)) {
            String[] split = read.split(separator);
            buff.append(split[0]).append(separator);
            statements.add(buff.toString());
            if (split.length > 1) {
              buff = new StringBuilder(split[1]);
            } else {
              buff = new StringBuilder();
            }
          } else {
            buff.append(read).append("\n");
          }
        }
      }
    } while (read != null);
  }

  public void setSeparator(String text) {
    this.separator = text;
  }

  public String getSeparator() {
    return separator;
  }

  public static SqlScriptRunnerChain newInstance() {
    return new SqlScriptRunnerChain();
  }

  private boolean myPrint;

  public boolean getPrint() {
    return this.myPrint;
  }

  public void setPrint(boolean value) {
    this.myPrint = value;
  }

  private boolean myExecute;

  public boolean getExecute() {
    return this.myExecute;
  }

  public void setExecute(boolean value) {
    this.myExecute = value;
  }
}
