/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.webflux.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceException;
import jakarta.validation.ValidationException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MimeType;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public abstract class WebFluxConfigBase {
    private static final Logger LOG = LoggerFactory.getLogger(WebFluxConfigBase.class);
    @Autowired
    protected ObjectMapper objectMapper;
    @Value(value="#{environment.getActiveProfiles()}")
    protected List<String> activeProfiles;

    @Bean
    public RouterFunction<ServerResponse> swaggerRouterFunction() {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)"/swagger-ui/index.html"), req -> ServerResponse.permanentRedirect((URI)URI.create("../webjars/swagger-ui/index.html")).build());
    }

    public void addCorsMappings(CorsRegistry registry) {
    }

    public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
        configurer.registerDefaults(true);
        configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(this.objectMapper, new MimeType[0]));
        configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(this.objectMapper, new MimeType[0]));
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", this.corsConfiguration());
        return source;
    }

    protected CorsConfiguration corsConfiguration() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedOrigins(Collections.singletonList("*"));
        config.setAllowedMethods(Collections.singletonList("*"));
        config.setAllowedHeaders(Collections.singletonList("*"));
        return config;
    }

    public ErrorWebExceptionHandler baseExceptionHandler(ObjectMapper objectMapper) {
        return (exchange, t) -> {
            HttpStatusCode status = this.statusCodeFor(t);
            ServerHttpResponse rsp = exchange.getResponse();
            DataBufferFactory bufferFactory = rsp.bufferFactory();
            Mono dataBuffer = Mono.just((Object)bufferFactory.allocateBuffer(1024)).map(b -> {
                try {
                    Throwable e = t;
                    if (status == HttpStatus.BAD_REQUEST && t.getCause() != null) {
                        e = t.getCause();
                    }
                    String errorDetails = this.errorDetails(e);
                    return b.write(objectMapper.writeValueAsBytes((Object)ResultDetail.error((Object)errorDetails, (String)status.toString(), e.getClass())));
                }
                catch (JsonProcessingException e) {
                    LOG.error("Error during error handling", (Throwable)e);
                    return b.write(e.getMessage().getBytes());
                }
            });
            rsp.setStatusCode(status);
            rsp.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            return rsp.writeWith((Publisher)dataBuffer);
        };
    }

    protected String errorDetails(Throwable t) {
        if (this.activeProfiles.contains("prod") || this.activeProfiles.contains("noErrorDetails")) {
            return null;
        }
        return t.getMessage();
    }

    protected HttpStatusCode statusCodeFor(Throwable t) {
        if (t instanceof ValidationException || t instanceof IllegalArgumentException || t instanceof ServerWebInputException) {
            LOG.debug("Handling bad request error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
            return HttpStatus.BAD_REQUEST;
        }
        if (t instanceof EntityNotFoundException || t instanceof EntityExistsException || t instanceof NonUniqueResultException || t instanceof NoResultException) {
            LOG.debug("Handling user persistence exception {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
            return HttpStatus.BAD_REQUEST;
        }
        if (t instanceof PersistenceException) {
            LOG.debug("Handling server persistence exception {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        if (t instanceof WebClientResponseException) {
            LOG.warn("Handling external service error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
            return ((WebClientResponseException)t).getStatusCode();
        }
        if (t instanceof ResponseStatusException) {
            LOG.warn("Handling external response service error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
            return ((ResponseStatusException)t).getStatusCode();
        }
        LOG.error("Internal server error", t);
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

