/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.webflux.filter;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.server.PathContainer;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathPatternMatcher {
    private final List<PathPattern> includePatterns;
    private final List<PathPattern> excludePatterns;
    private PathPatternParser parser = new PathPatternParser();

    public PathPatternMatcher(List<String> includePathPatterns, List<String> excludePathPatterns) {
        this.includePatterns = includePathPatterns.stream().map(arg_0 -> ((PathPatternParser)this.parser).parse(arg_0)).collect(Collectors.toList());
        this.excludePatterns = excludePathPatterns.stream().map(arg_0 -> ((PathPatternParser)this.parser).parse(arg_0)).collect(Collectors.toList());
    }

    public boolean matches(ServerWebExchange e) {
        return this.matches(e.getRequest().getPath().pathWithinApplication());
    }

    public boolean matches(PathContainer path) {
        boolean included = this.includePatterns.stream().anyMatch(p -> p.matches(path));
        boolean excluded = this.excludePatterns.stream().anyMatch(p -> p.matches(path));
        return (this.includePatterns.isEmpty() || included) && !excluded;
    }
}

