/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.webflux.filter;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.event.RestEvent;
import inc.yukawa.chain.base.webflux.filter.PathPatternMatcher;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RestEventWebFilter
implements WebFilter,
InitializingBean {
    protected final Function<RestEvent, Mono<RestEvent>> eventConsumer;
    protected PathPatternMatcher pathPatternMatcher;
    @Value(value="${chain.filter.restEvent.enabled:true}")
    protected boolean enabled;
    @Value(value="${chain.filter.restEvent.includePathPatterns:}")
    protected List<String> includePathPatterns;
    @Value(value="${chain.filter.restEvent.excludePathPatterns:}")
    protected List<String> excludePathPatterns;
    @Value(value="${chain.filter.restEvent.requestBody.include:false}")
    protected boolean includeRequestBody;
    @Value(value="${chain.filter.restEvent.requestBody.includePathPatterns:}")
    protected List<String> includeRequestBodyPathPatterns;
    @Value(value="${chain.filter.restEvent.requestBody.excludePathPatterns:}")
    protected List<String> excludeRequestBodyPathPatterns;
    protected PathPatternMatcher includeRequestBodyPatternMatcher;
    @Value(value="${chain.filter.restEvent.responseBody.include:false}")
    protected boolean includeResponseBody;
    @Value(value="${chain.filter.restEvent.responseBody.includePathPatterns:}")
    protected List<String> includeResponseBodyPathPatterns;
    @Value(value="${chain.filter.restEvent.responseBody.excludePathPatterns:}")
    protected List<String> excludeResponseBodyPathPatterns;
    protected PathPatternMatcher includeResponseBodyPatternMatcher;
    @Value(value="${chain.filter.restEvent.includeRequestBody.maxByteCount:102400}")
    protected int requestMaxByteCount = 102400;
    @Value(value="${chain.filter.restEvent.includeResponseBody.maxByteCount:102400}")
    protected int responseMaxByteCount = 102400;
    @Value(value="${chain.filter.restEvent.requestHeaders.include:false}")
    protected boolean includeRequestHeaders;
    @Value(value="${chain.filter.restEvent.requestHeaders.includeNamesRegExp:.*}")
    protected Pattern includeRequestHeaderNamesRegExpPattern;

    public RestEventWebFilter(Function<RestEvent, Mono<RestEvent>> eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (!this.enabled || !this.matches(exchange)) {
            return chain.filter(exchange);
        }
        long startTime = System.currentTimeMillis();
        CaptureExchange captureExchange = new CaptureExchange(exchange);
        return chain.filter((ServerWebExchange)captureExchange).then(captureExchange.capturePrincipal()).doFinally(signalType -> this.asEvent(startTime, captureExchange).flatMap(this.eventConsumer).subscribeOn(Schedulers.boundedElastic()).subscribe());
    }

    protected boolean matches(ServerWebExchange exchange) {
        return this.pathPatternMatcher.matches(exchange);
    }

    private Mono<RestEvent> asEvent(long startTime, CaptureExchange exchange) {
        int took = (int)(System.currentTimeMillis() - startTime);
        BodyCaptureRequest req = exchange.getRequest();
        RestEvent e = new RestEvent();
        e.setEventId(req.getId());
        e.setCreated(new Change(null, new Date(startTime)));
        e.setTook(Integer.valueOf(took));
        e.getCreated().setUser(exchange.getPrincipalName());
        e.setPath(req.getPath().value());
        e.setMethod(req.getMethod().name());
        e.setQueryParams(req.getQueryParams().toSingleValueMap());
        e.setRemoteAddress(Objects.toString(req.getRemoteAddress()));
        e.setRequestHeaders(exchange.getRequest().getHeadersMap());
        e.setRequestBody((Object)exchange.getRequest().getFullBody());
        e.setResponseBody((Object)exchange.getResponse().getFullBody());
        e.setResponseStatusCode(exchange.getResponse().getStatusCode() != null ? Integer.valueOf(exchange.getResponse().getStatusCode().value()) : null);
        return Mono.just((Object)e);
    }

    public void setIncludeRequestBody(boolean includeRequestBody) {
        this.includeRequestBody = includeRequestBody;
    }

    public void setIncludeResponseBody(boolean includeResponseBody) {
        this.includeResponseBody = includeResponseBody;
    }

    public void setRequestMaxByteCount(int requestMaxByteCount) {
        this.requestMaxByteCount = requestMaxByteCount;
    }

    public void setResponseMaxByteCount(int responseMaxByteCount) {
        this.responseMaxByteCount = responseMaxByteCount;
    }

    public void afterPropertiesSet() {
        this.pathPatternMatcher = new PathPatternMatcher(this.includePathPatterns, this.excludePathPatterns);
        this.includeRequestBodyPatternMatcher = new PathPatternMatcher(this.includeRequestBodyPathPatterns, this.excludeRequestBodyPathPatterns);
        this.includeResponseBodyPatternMatcher = new PathPatternMatcher(this.includeResponseBodyPathPatterns, this.excludeResponseBodyPathPatterns);
    }

    public class CaptureExchange
    extends ServerWebExchangeDecorator {
        private String principalName;
        private BodyCaptureRequest bodyCaptureRequest;
        private BodyCaptureResponse bodyCaptureResponse;

        public CaptureExchange(ServerWebExchange exchange) {
            super(exchange);
            PathContainer path = exchange.getRequest().getPath().pathWithinApplication();
            this.bodyCaptureRequest = new BodyCaptureRequest(exchange.getRequest(), path);
            this.bodyCaptureResponse = new BodyCaptureResponse(exchange.getResponse(), path);
        }

        public Mono<Void> capturePrincipal() {
            return super.getPrincipal().map(Principal::getName).defaultIfEmpty((Object)"anonymous").doOnNext(pn -> {
                this.principalName = pn;
            }).then();
        }

        public BodyCaptureRequest getRequest() {
            return this.bodyCaptureRequest;
        }

        public BodyCaptureResponse getResponse() {
            return this.bodyCaptureResponse;
        }

        public String getPrincipalName() {
            return this.principalName;
        }
    }

    protected class BodyCaptureRequest
    extends ServerHttpRequestDecorator {
        private final StringBuilder body;
        private Map<String, String> headersMap;
        private PathContainer path;

        public BodyCaptureRequest(ServerHttpRequest delegate, PathContainer path) {
            super(delegate);
            this.body = new StringBuilder();
            this.path = path;
        }

        public Flux<DataBuffer> getBody() {
            return super.getBody().doOnNext(this::capture);
        }

        public HttpHeaders getHeaders() {
            if (RestEventWebFilter.this.includeRequestHeaders) {
                this.headersMap = new HashMap<String, String>();
                this.getDelegate().getHeaders().toSingleValueMap().entrySet().stream().filter(e -> RestEventWebFilter.this.includeRequestHeaderNamesRegExpPattern.matcher((CharSequence)e.getKey()).find()).forEach(e -> this.headersMap.put((String)e.getKey(), (String)e.getValue()));
                this.headersMap.keySet().removeIf(name -> name.toLowerCase().startsWith("auth"));
            }
            return super.getHeaders();
        }

        private void capture(DataBuffer buffer) {
            if (!RestEventWebFilter.this.includeRequestBody || !RestEventWebFilter.this.includeRequestBodyPatternMatcher.matches(this.path)) {
                return;
            }
            this.body.append(StandardCharsets.UTF_8.decode(buffer.asByteBuffer(0, Math.min(buffer.readableByteCount(), RestEventWebFilter.this.requestMaxByteCount))));
        }

        public String getFullBody() {
            return this.body.toString();
        }

        public Map<String, String> getHeadersMap() {
            return this.headersMap;
        }
    }

    protected class BodyCaptureResponse
    extends ServerHttpResponseDecorator {
        private final StringBuilder body;
        private PathContainer path;

        public BodyCaptureResponse(ServerHttpResponse delegate, PathContainer path) {
            super(delegate);
            this.body = new StringBuilder();
            this.path = path;
        }

        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
            Flux buffer = Flux.from(body);
            return super.writeWith((Publisher)buffer.doOnNext(this::capture));
        }

        private void capture(DataBuffer buffer) {
            if (!RestEventWebFilter.this.includeResponseBody || !RestEventWebFilter.this.includeResponseBodyPatternMatcher.matches(this.path)) {
                return;
            }
            this.body.append(StandardCharsets.UTF_8.decode(buffer.asByteBuffer(0, Math.min(buffer.readableByteCount(), RestEventWebFilter.this.responseMaxByteCount))));
        }

        public String getFullBody() {
            return this.body.toString();
        }
    }
}

