/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.config;

import inc.yukawa.chain.kafka.config.KafkaAdminConfigBase;
import inc.yukawa.chain.kafka.connect.admin.ConnectAdmin;
import inc.yukawa.chain.kafka.connect.admin.ConnectClient;
import inc.yukawa.chain.kafka.connect.admin.ConnectClientWebFlux;
import java.util.HashMap;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class KafkaAdminConfig
extends KafkaAdminConfigBase {
    @Value(value="${chain.console.topic.partitions:2}")
    private int partitions;
    @Value(value="${chain.console.topic.replication:1}")
    private short replication;
    @Value(value="${app.prefix}")
    protected String appPrefix;
    @Value(value="${chain.admin.connect.rest.url}")
    protected String connectUrl;
    @Value(value="${chain.admin.connect.elastic.url}")
    protected String elasticUrl;
    @Value(value="${chain.docs.file.data.topic}")
    private String fileInfoTopic;

    @Bean(value={"docs.KafkaConnectClient"})
    public ConnectClient kafkaConnectClient() {
        return new ConnectClientWebFlux(WebClient.builder().baseUrl(this.connectUrl).build());
    }

    @Bean(value={"docs.KafkaConnectAdmin"})
    public ConnectAdmin kafkaConnectAdmin(@Qualifier(value="docs.KafkaConnectClient") ConnectClient client) {
        HashMap<String, String> fileInfoConfig = new HashMap<String, String>();
        fileInfoConfig.put("connector.class", "io.confluent.connect.elasticsearch.ElasticsearchSinkConnector");
        fileInfoConfig.put("type.name", "_doc");
        fileInfoConfig.put("errors.log.include.messages", "true");
        fileInfoConfig.put("behavior.on.null.values", "delete");
        fileInfoConfig.put("topics", "");
        fileInfoConfig.put("name", this.fileInfoTopic);
        fileInfoConfig.put("connection.url", this.elasticUrl);
        fileInfoConfig.put("value.converter", "org.apache.kafka.connect.json.JsonConverter");
        fileInfoConfig.put("value.converter.schemas.enable", "false");
        fileInfoConfig.put("key.converter.schemas.enable", "false");
        fileInfoConfig.put("key.ignore", "false");
        fileInfoConfig.put("errors.log.enable", "false");
        fileInfoConfig.put("topics.regex", this.fileInfoTopic);
        fileInfoConfig.put("connection.timeout.ms", "5000");
        fileInfoConfig.put("read.timeout.ms", "5000");
        fileInfoConfig.put("schema.ignore", "true");
        fileInfoConfig.put("behavior.on.malformed.documents", "warn");
        HashMap<String, HashMap<String, String>> connectors = new HashMap<String, HashMap<String, String>>();
        connectors.put(this.fileInfoTopic, fileInfoConfig);
        return new ConnectAdmin(client, connectors);
    }

    @Bean(value={"docs.FileDataTopic"})
    public NewTopic useCaseEventTopic(@Value(value="${chain.docs.file.data.topic}") String topic) {
        return this.initCompactTopic(new NewTopic(topic, this.partitions, this.replication));
    }

    @Bean
    public KafkaAdmin kafkaAdmin() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("bootstrap.servers", this.bootstrapServers);
        return new KafkaAdmin(configs);
    }

    protected NewTopic initTopic(NewTopic topic) {
        if (topic.configs() == null) {
            topic.configs(new HashMap());
        }
        return topic;
    }
}

