/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.file.FileInfo;
import inc.yukawa.chain.kafka.config.KafkaStreamsConfigBase;
import inc.yukawa.chain.kafka.util.StreamUtil;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
public class KafkaConfig
extends KafkaStreamsConfigBase {
    @Value(value="${server.port}")
    private final int port = 8010;
    @Value(value="${server.host:auto}")
    private final String host = "auto";

    public ObjectMapper objectMapper() {
        ObjectMapper mapper = super.objectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    @Bean(value={"console.StreamsProps"})
    public Properties streamsProps() {
        Properties props = this.baseStreamsProps();
        props.put("application.server", StreamUtil.initHostAddress((String)"auto") + ":" + 8010);
        props.put("application.id", this.appId);
        props.put("topology.optimization", "all");
        return props;
    }

    @Bean
    public ProducerFactory<String, Object> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfig(), Serdes.String().serializer(), (Serializer)new JsonSerializer(this.objectMapper()));
    }

    @Bean
    public KafkaTemplate<String, FileInfo> fileInfoProducer(@Qualifier(value="docs.FileDataTopic") NewTopic topic) {
        return this.kafkaTemplate(Serdes.String().serializer(), (Serializer)new JsonSerializer(this.objectMapper()), topic.name());
    }
}

