/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.config;

import inc.yukawa.chain.base.core.domain.access.AccessRights;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.file.FileInfo;
import inc.yukawa.chain.base.core.domain.file.Type;
import inc.yukawa.chain.modules.docs.service.repository.FileInfoRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import reactor.core.scheduler.Schedulers;

@Configuration
@Profile(value={"sample"})
public class SampleConfig {
    private FileInfoRepository repo;

    public SampleConfig(FileInfoRepository repo) {
        this.repo = repo;
    }

    @Bean(value={"docs.sampleFiles"})
    public List<FileInfo> sampleFiles() {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        files.add(this.dirProto("sample_dir", null));
        files.add(this.dirProto("sample_dir2", null));
        files.add(this.fileProto("someDoc.docx", "sample_dir", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"));
        files.add(this.fileProto("somePdf.pdf", "sample_dir", "application/pdf"));
        files.add(this.fileProto("someText.txt", "sample_dir2", "text/plain"));
        return files;
    }

    @Bean(value={"docs.sampleCreator"})
    public ApplicationRunner sampleCreator(@Qualifier(value="docs.sampleFiles") List<FileInfo> sampleFiles) {
        return args -> sampleFiles.stream().map(f -> this.repo.put(f.getFileId(), f)).forEach(u -> u.subscribeOn(Schedulers.elastic()).subscribe());
    }

    private FileInfo dirProto(String dirName, String parentId) {
        FileInfo dir = this.fileProto(dirName, parentId);
        dir.setType(Type.DIRECTORY);
        dir.setMime(null);
        return dir;
    }

    private FileInfo fileProto(String fileName, String parentId) {
        return this.fileProto(fileName, parentId, "text/plain");
    }

    private FileInfo fileProto(String fileName, String parentId, String mime) {
        AccessRights access = new AccessRights();
        access.setReadUsers(new HashSet<String>(Arrays.asList("sample_reader", "sample_writer")));
        access.setWriteUsers(new HashSet<String>(Arrays.asList("sample_writer")));
        access.setReadGroups(new HashSet<String>(Arrays.asList("SAMPLE_READERS", "ADMINS")));
        access.setWriteGroups(new HashSet<String>(Arrays.asList("SAMPLE_WRITERS", "ADMINS")));
        FileInfo f = new FileInfo();
        f.setFileId(fileName);
        f.setParentId(parentId);
        f.setFileName(fileName);
        f.setFileContent("someTestFileBody".getBytes());
        f.setMime(mime);
        f.setType(Type.FILE);
        f.setTags(Collections.singletonList("sample"));
        f.setAccessRights(access);
        f.setCreated(new Change("sample", new Date()));
        f.setChange(f.getCreated());
        return f;
    }
}

