/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.config;

import inc.yukawa.chain.base.rest.config.SwaggerConfigBase;
import inc.yukawa.chain.kafka.util.StreamUtil;
import inc.yukawa.chain.modules.docs.service.rest.DocsManagementRest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spi.service.contexts.SecurityContextBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebFlux;

@Configuration
@EnableSwagger2WebFlux
@Profile(value={"!prod"})
public class SwaggerConfig
extends SwaggerConfigBase {
    @Autowired(required=false)
    @Qualifier(value="docs.PermitEndpoints")
    protected List<String> permitAllEndpoints;

    protected Docket apiBase() {
        return new Docket(DocumentationType.SWAGGER_2).host(this.swaggerHost()).protocols(new HashSet<String>(Arrays.asList(this.swaggerSchemes()))).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)DocsManagementRest.class.getPackage().getName())).paths(PathSelectors.any()).build().ignoredParameterTypes(new Class[]{ServerWebExchange.class}).genericModelSubstitutes(new Class[]{Mono.class}).genericModelSubstitutes(new Class[]{ResponseEntity.class}).genericModelSubstitutes(new Class[]{Flux.class});
    }

    @Bean
    @Profile(value={"open"})
    public Docket apiOpen() {
        return this.apiBase();
    }

    @Bean
    @Profile(value={"!open"})
    public Docket apiJwt() {
        return this.apiBase().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().contact(this.contract()).title("CHAIN Docs").description(String.format("%s:%d (%s)", StreamUtil.initHostAddress((String)"auto"), this.extPort, new Date())).version("2.0.2").build();
    }

    protected Contact contract() {
        return new Contact("Yukawa Systems", "http://www.yukawa.de", "info@chain.yukawa.de");
    }

    private List<SecurityScheme> securitySchemes() {
        return Arrays.asList(this.oauth());
    }

    private List<SecurityContext> securityContexts() {
        Predicate any = PathSelectors.any();
        if (this.permitAllEndpoints != null) {
            for (String endpoint : this.permitAllEndpoints) {
                any = any.and(PathSelectors.ant((String)endpoint).negate());
            }
        }
        SecurityContextBuilder scb = SecurityContext.builder().securityReferences(this.tokenAuthRefs()).forPaths(any);
        return Collections.singletonList(scb.build());
    }

    SecurityScheme oauth() {
        return new OAuthBuilder().name("OAuthLogin").scopes(Arrays.asList(this.scopes())).grantTypes(this.grantTypes()).build();
    }

    List<GrantType> grantTypes() {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        grantTypes.add((GrantType)new ResourceOwnerPasswordCredentialsGrant(this.swaggerLoginFormUrl()));
        return grantTypes;
    }

    private AuthorizationScope[] scopes() {
        return new AuthorizationScope[0];
    }

    @Bean
    @Profile(value={"!open"})
    SecurityConfiguration securityConfiguration() {
        return SecurityConfigurationBuilder.builder().clientId(this.appPrefix + "docs").realm("ChainRealm").appName(this.appPrefix + "docs").scopeSeparator(",").build();
    }

    protected List<SecurityReference> tokenAuthRefs() {
        return Arrays.asList(new SecurityReference("OAuthLogin", this.scopes()));
    }
}

