/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.elastic;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.access.AccessRightsFilter;
import inc.yukawa.chain.base.core.domain.file.FileInfo;
import inc.yukawa.chain.base.core.domain.file.FileInfoFilter;
import inc.yukawa.chain.base.elastic.dao.ElasticReadDao;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class FileInfoElasticReadDao
extends ElasticReadDao<String, FileInfo, FileInfoFilter> {
    private static final List<String> FULL_TEXT_FIELDS = Collections.singletonList("fileName");
    public static final String[] KEYWORD_FIELDS = new String[]{"fileName", "tags"};
    public static final String ROOT = "ROOT";

    @Autowired
    public FileInfoElasticReadDao(@Value(value="${chain.docs.file.data.index}") String index, RestHighLevelClient restClient, ObjectMapper mapper) {
        super(index, restClient, mapper, FileInfo.class);
    }

    protected BoolQueryBuilder findQueryBuilder(FileInfoFilter filter) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        this.idQueryOn(builder, () -> ((FileInfoFilter)filter).getFileId());
        if (ROOT.equals(filter.getParentId())) {
            builder.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)"parentId", (String)"*"));
        } else {
            this.termsQueryOn(builder, () -> ((FileInfoFilter)filter).getParentId(), "parentId");
        }
        this.termsQueryOn(builder, () -> filter.getType() != null ? filter.getType().name() : null, "type");
        this.termsQueryOn(builder, () -> ((FileInfoFilter)filter).getTag(), "tags");
        this.matchQueryOn(builder, () -> ((FileInfoFilter)filter).getFileName(), "fileName");
        if (filter.getKeyword() != null) {
            builder.must((QueryBuilder)this.searchKeywordBuilder(filter.getKeyword().toLowerCase(), KEYWORD_FIELDS));
        }
        AccessRightsFilter af = filter.getAccessFilter();
        if (filter.getAccessFilter() != null) {
            if (af.getReadUsers() != null || af.getReadGroups() != null) {
                this.accessibleForRead(builder, af);
            }
            if (af.getWriteUsers() != null || af.getWriteGroups() != null) {
                this.accessibleForWrite(builder, af);
            }
        }
        return builder;
    }

    private void accessibleForWrite(BoolQueryBuilder builder, AccessRightsFilter af) {
        DisMaxQueryBuilder orQuery = QueryBuilders.disMaxQuery();
        this.multiTermsQueryOn(orQuery, () -> ((AccessRightsFilter)af).getWriteUsers(), "accessRights.writeUsers");
        this.multiTermsQueryOn(orQuery, () -> ((AccessRightsFilter)af).getWriteGroups(), "accessRights.writeGroups");
        builder.filter((QueryBuilder)orQuery);
    }

    private void accessibleForRead(BoolQueryBuilder builder, AccessRightsFilter af) {
        DisMaxQueryBuilder orQuery = QueryBuilders.disMaxQuery();
        this.multiTermsQueryOn(orQuery, () -> ((AccessRightsFilter)af).getReadUsers(), "accessRights.readUsers");
        this.multiTermsQueryOn(orQuery, () -> ((AccessRightsFilter)af).getReadGroups(), "accessRights.readGroups");
        builder.filter((QueryBuilder)orQuery);
    }

    protected String mapOrderBy(String field) {
        if ("fileId".equals(field)) {
            return "_id";
        }
        if (FULL_TEXT_FIELDS.contains(field)) {
            return field + ".keyword";
        }
        return super.mapOrderBy(field);
    }

    protected void multiTermsQueryOn(DisMaxQueryBuilder builder, Supplier<Collection<?>> getter, String field) {
        Collection<?> values = getter.get();
        if (values != null) {
            builder.add((QueryBuilder)QueryBuilders.termsQuery((String)field, values));
        }
    }
}

