/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.management;

import inc.yukawa.chain.base.core.domain.access.AccessRights;
import inc.yukawa.chain.base.core.domain.access.AccessRightsFilter;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.file.FileInfo;
import inc.yukawa.chain.base.core.domain.file.FileInfoFilter;
import inc.yukawa.chain.base.core.domain.file.Type;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.modules.docs.core.aspect.DocsManagementAspect;
import inc.yukawa.chain.modules.docs.core.aspect.FileStoreAspect;
import inc.yukawa.chain.modules.docs.service.repository.FileInfoRepository;
import inc.yukawa.chain.modules.docs.service.security.AuthContextService;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.elasticsearch.common.util.set.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class DocsManagementService
implements DocsManagementAspect {
    private static final Logger LOG = LoggerFactory.getLogger(DocsManagementService.class);
    private final FileInfoRepository fileInfoRepo;
    private final AuthContextService authContextSrv;
    private final FileStoreAspect fileStore;

    public DocsManagementService(FileInfoRepository fileInfoRepo, AuthContextService authContextSrv, FileStoreAspect fileStore) {
        this.fileInfoRepo = fileInfoRepo;
        this.authContextSrv = authContextSrv;
        this.fileStore = fileStore;
    }

    public Mono<FileInfo> loadFile(FileInfoFilter filter) {
        return this.withCallerReadScope(filter).flatMap(f -> this.fileInfoRepo.read(f));
    }

    public Mono<Tuple2<FileInfo, Resource>> downloadFile(FileInfoFilter filter) {
        return this.loadFile(filter).zipWhen(fi -> this.fileStore.loadFile(fi.getFileId()));
    }

    public Mono<QueryResult<FileInfo>> queryFiles(FileInfoFilter filter) {
        return this.withCallerReadScope(filter).flatMap(f -> this.fileInfoRepo.query(f));
    }

    public Mono<Void> uploadFile(FileInfo fileInfo, Mono<FilePart> filePart) {
        fileInfo.setFileId(UUID.randomUUID().toString());
        return this.fileInfoRepo.put(fileInfo.getFileId(), fileInfo).then(this.fileStore.putFile(fileInfo.getFileId(), filePart));
    }

    public Mono<Void> deleteFiles(FileInfoFilter fileInfoFilter) {
        return this.withCallerWriteScope(fileInfoFilter).flatMap(f -> this.fileInfoRepo.read(f)).zipWhen(f -> this.fileInfoRepo.deleteKey(f.getFileId()), (fi, i) -> fi).flatMap(fi -> this.fileStore.deleteFile(fi.getFileId()));
    }

    public Mono<FileInfo> createDir(FileInfo dir) {
        Assert.hasText((String)dir.getFileName(), (String)"fileName is mandatory");
        return this.loadByPath(dir.getFileName(), dir.getParentId()).flatMap(d -> Mono.error((Throwable)new DuplicateKeyException(d.getFileName() + "@" + d.getParentId()))).defaultIfEmpty((Object)dir).flatMap(this::withChange).flatMap(this::withPerms).map(d -> {
            d.setCreated(d.getChange());
            d.setFileId(UUID.randomUUID().toString());
            d.setType(Type.DIRECTORY);
            d.setMime(null);
            d.setFileContent(null);
            return d;
        }).flatMap(this::withPerms).flatMap(f -> this.fileInfoRepo.put(f.getFileId(), f));
    }

    private Mono<FileInfo> withPerms(FileInfo fileInfo) {
        if (fileInfo.getAccessRights() != null) {
            return Mono.just((Object)fileInfo);
        }
        if (fileInfo.getParentId() == null) {
            fileInfo.setAccessRights(new AccessRights());
            fileInfo.getAccessRights().setReadUsers((Set)Sets.newHashSet((Object[])new String[]{fileInfo.getChange().getUser()}));
            fileInfo.getAccessRights().setWriteUsers((Set)Sets.newHashSet((Object[])new String[]{fileInfo.getChange().getUser()}));
            return Mono.just((Object)fileInfo);
        }
        return this.fileInfoRepo.load(fileInfo.getParentId()).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("no such parent"))).map(p -> {
            fileInfo.setAccessRights(p.getAccessRights());
            return fileInfo;
        });
    }

    private Mono<FileInfo> withChange(FileInfo file) {
        return this.authContextSrv.authPrincipal().map(user -> {
            file.setChange(new Change(user, new Date()));
            return file;
        });
    }

    private Mono<FileInfo> loadByPath(String fileName, String parentId) {
        FileInfoFilter f = new FileInfoFilter();
        f.setFileName(fileName);
        f.setParentId(parentId);
        return this.fileInfoRepo.read(f);
    }

    private Mono<FileInfoFilter> withCallerReadScope(FileInfoFilter filter) {
        return this.callerReadScope().map(scope -> {
            filter.setAccessFilter(scope);
            return filter;
        }).defaultIfEmpty((Object)filter);
    }

    private Mono<FileInfoFilter> withCallerWriteScope(FileInfoFilter filter) {
        return this.callerWriteScope().map(scope -> {
            filter.setAccessFilter(scope);
            return filter;
        });
    }

    private Mono<AccessRightsFilter> callerReadScope() {
        return this.authContextSrv.authUserRoles().filter(roles -> !roles.contains("ROLE_ADMIN") && !roles.contains("ROLE_DOCS_ADMIN")).flatMap(roles -> this.callerAndGroups()).map(tuple2 -> new AccessRightsFilter((Set)tuple2.getT1(), null, (Set)tuple2.getT2(), null));
    }

    private Mono<AccessRightsFilter> callerWriteScope() {
        return this.callerAndGroups().map(tuple2 -> new AccessRightsFilter(null, (Set)tuple2.getT1(), null, (Set)tuple2.getT2()));
    }

    private Mono<Tuple2<Set<String>, Set<String>>> callerAndGroups() {
        return this.authContextSrv.authPrincipal().map(Collections::singleton).zipWith(this.authContextSrv.authUserGroups()).doOnNext(scope -> LOG.debug("Caller scope: user={}, groups={}", scope.getT1(), scope.getT2()));
    }
}

