/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.management;

import inc.yukawa.chain.modules.docs.core.aspect.FileStoreAspect;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class FileSystemStoreService
implements FileStoreAspect {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemStoreService.class);
    private Path root;

    public FileSystemStoreService(Path root) {
        this.root = root;
    }

    public Mono<Resource> loadFile(String fileId) {
        return Mono.fromSupplier(() -> new FileSystemResource(this.toPath(fileId)));
    }

    public Mono<Void> putFile(String fileId, Mono<FilePart> filePart) {
        Path dest = this.toPath(fileId);
        Mono createDir = Mono.create(sink -> {
            try {
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                LOG.trace("Created dir: {}", (Object)dest.getParent());
                sink.success((Object)dest);
            }
            catch (IOException e) {
                LOG.error("Dir creation error for: " + dest.getParent(), (Throwable)e);
                sink.error((Throwable)e);
            }
        });
        return createDir.then(filePart).flatMap(part -> part.transferTo(dest)).doOnNext(v -> LOG.info("Saved {}", (Object)dest)).doOnError(e -> this.deleteFile(fileId).subscribeOn(Schedulers.elastic()).subscribe());
    }

    public Mono<Void> deleteFile(String fileId) {
        return Mono.create(sink -> {
            try {
                Path dest = this.toPath(fileId);
                boolean b = Files.deleteIfExists(dest);
                LOG.info("Deleted {} with status {}", (Object)dest, (Object)b);
                sink.success();
            }
            catch (IOException e) {
                LOG.error("Delete error for: " + this.toPath(fileId), (Throwable)e);
                sink.error((Throwable)e);
            }
        });
    }

    private Path toPath(String fileId) {
        this.validate(fileId);
        return this.root.resolve(fileId.substring(0, 2)).resolve(fileId);
    }

    private void validate(String fileId) {
        Assert.hasText((String)fileId, (String)"fileId can't be blank");
        Assert.isTrue((fileId.length() > 2 ? 1 : 0) != 0, (String)"fileId has to be at least 3 chars long");
        Assert.isTrue((boolean)FileSystemStoreService.isValidFileName(fileId), (String)"illegal fileId");
    }

    public static boolean isValidFileName(String fileName) {
        try {
            new File(fileName).getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

