/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.rest;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.elastic.dao.ElasticIndexAdmin;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Api(value="Admin", tags={"Admin"})
@RestController
@RequestMapping(value={"/admin"}, produces={"application/json", "text/xml"})
@Profile(value={"admin-aspect", "all-aspects", "default"})
public class AdminRest {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRest.class);
    private final ElasticIndexAdmin fileInfoIndexAdmin;
    @Value(value="${chain.docs.file.data.index}")
    private String fileInfoIndex;

    public AdminRest(@Qualifier(value="docs.fileInfoIndexAdmin") ElasticIndexAdmin fileInfoIndexAdmin) {
        this.fileInfoIndexAdmin = fileInfoIndexAdmin;
    }

    @PostMapping(value={"/index/fileInfo"})
    @ApiOperation(value="buildFileInfoIndex", notes="rebuild search index from topics", response=EditResult.class)
    public Mono<EditResult> buildFileInfoIndex(@RequestParam(value="delete", defaultValue="true") boolean delete) {
        LOG.info("buildIndex with delete={}", (Object)delete);
        CompletableFuture res = new CompletableFuture();
        this.fileInfoIndexAdmin.buildIndex(this.fileInfoIndex, delete, s -> res.complete(new EditResult("buildFileInfoIndex", this.fileInfoIndexAdmin.getClass(), this.fileInfoIndex)), res::completeExceptionally);
        return Mono.fromFuture(res);
    }

    @GetMapping(value={"/index/fileInfo"})
    @ApiOperation(value="loadFileInfoMapping")
    public Mono<Map<String, ?>> loadFileInfoMapping() {
        return this.fileInfoIndexAdmin.loadMapping();
    }
}

