/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.rest;

import inc.yukawa.chain.base.core.domain.file.FileInfo;
import inc.yukawa.chain.base.core.domain.file.FileInfoFilter;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.modules.docs.core.aspect.DocsManagementAspect;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Api(value="DocsManagement", tags={"DocsManagement"})
@RestController
@RequestMapping(value={"/docs"}, produces={"application/json", "text/xml"})
@Validated
public class DocsManagementRest {
    private static final Logger log = LoggerFactory.getLogger(DocsManagementRest.class);
    private final DocsManagementAspect aspect;

    @Autowired
    public DocsManagementRest(DocsManagementAspect aspect) {
        this.aspect = aspect;
    }

    @GetMapping(value={"/files/{fileId}"})
    @ApiOperation(value="loadFile", response=FileInfo.class)
    public Mono<FileInfo> loadFile(@PathVariable(value="fileId") @NotBlank String fileId) {
        log.info("loadFile: {}", (Object)fileId);
        return this.aspect.loadFile(new FileInfoFilter(fileId));
    }

    @PostMapping(value={"/files/query"})
    @ApiOperation(value="queryFiles", response=QueryResult.class)
    public Mono<QueryResult<FileInfo>> queryFiles(@RequestBody @NotNull @Validated FileInfoFilter filter) {
        log.info("queryFiles: {}", (Object)filter);
        return this.aspect.queryFiles(filter);
    }

    @GetMapping(value={"/files"})
    @ApiOperation(value="findFiles", response=FileInfo.class, responseContainer="List")
    public Flux<FileInfo> findFiles(@RequestParam(name="fileName", required=false) @NotBlank String fileName) {
        FileInfoFilter filter = new FileInfoFilter();
        filter.setFileName(fileName);
        log.info("findFiles: {}", (Object)filter);
        return this.queryFiles(filter).flatMapIterable(QueryResult::getItems);
    }

    @GetMapping(value={"/download/{fileId}"}, produces={"*/*"})
    @ApiOperation(value="downloadFile", response=Resource.class)
    public Mono<ResponseEntity<Resource>> downloadFile(@PathVariable(value="fileId") @ApiParam(required=true) @NotBlank String fileId) {
        log.info("downloadFile: {}", (Object)fileId);
        return this.aspect.downloadFile(new FileInfoFilter(fileId)).map(tuple -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + ((FileInfo)tuple.getT1()).getFileName()})).contentType(MediaType.parseMediaType((String)((FileInfo)tuple.getT1()).getMime())).body(tuple.getT2())).switchIfEmpty(Mono.just((Object)ResponseEntity.badRequest().build()));
    }

    @PostMapping(value={"/createDir"})
    @ApiOperation(value="createDir")
    public Mono<FileInfo> createDir(@RequestBody @NotNull @Validated FileInfo dir) {
        log.info("createDir: {}", (Object)dir);
        return this.aspect.createDir(dir);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    @ApiOperation(value="uploadFile")
    public Mono<Void> uploadFile(@RequestPart(value="info") FileInfo fileInfo, @RequestPart(value="file") Mono<FilePart> filePart) {
        log.info("uploadFile: {}", (Object)fileInfo);
        return this.aspect.uploadFile(fileInfo, filePart);
    }

    @DeleteMapping(value={"/files/{fileId}"})
    @ApiOperation(value="deleteFile")
    public Mono<Void> deleteFile(@PathVariable(value="fileId") String fileId) {
        log.info("deleteFile: {}", (Object)fileId);
        return this.aspect.deleteFiles(new FileInfoFilter(fileId));
    }
}

