/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.docs.service.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class AuthContextService {
    @Value(value="${user.account.details.groupsKey:groups}")
    protected String groupsKey;

    public Mono<Authentication> auth() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication);
    }

    public Mono<String> authPrincipal() {
        return this.auth().map(a -> (String)a.getPrincipal());
    }

    public Mono<Map<String, Object>> authDetails() {
        return this.auth().map(this::authDetailsFrom);
    }

    public Mono<Set<String>> authUserGroups() {
        return this.auth().map(this::authUserGroupsFrom);
    }

    public Mono<Set<String>> authUserRoles() {
        return this.auth().map(authentication -> authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
    }

    public Map<String, Object> authDetailsFrom(Authentication auth) {
        return auth.getDetails() != null ? (Map)auth.getDetails() : new HashMap();
    }

    public Set<String> authUserGroupsFrom(Authentication auth) {
        return new HashSet<String>(this.authDetailsFrom(auth).getOrDefault(this.groupsKey, Collections.emptyList()));
    }
}

