/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.kafka.config.KafkaInitConfigBase;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

public abstract class InitConfigBase<V extends Keyed<String>>
extends KafkaInitConfigBase<String> {
    private static final Logger LOG = LoggerFactory.getLogger(InitConfigBase.class);
    protected String name;
    protected Resource dataResource;
    protected String topic;

    public InitConfigBase(String name, Resource dataResource, ObjectMapper mapper, ReactiveKafkaProducerTemplate<String, Object> template, String topic) {
        super(mapper, template);
        this.name = name;
        this.dataResource = dataResource;
        this.topic = topic;
    }

    public void doInit() {
        List<V> data = this.readData();
        LOG.debug("[{}] {} init records: {}", new Object[]{this.name, data.size(), data.stream().map(Keyed::key).collect(Collectors.toList())});
        data.forEach(s -> this.sendObject(this.topic, (String)s.key(), s));
    }

    public String getName() {
        return this.name;
    }

    protected abstract TypeReference<List<V>> typeRef();

    protected List<V> readData() {
        return super.parseObject(this.dataResource, this.typeRef()).stream().peek(this::enhance).collect(Collectors.toList());
    }

    protected void enhance(V record) {
    }
}

