/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.config;

import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.config.TopicBuilder;

public abstract class KafkaAdminConfigBase {
    @Value(value="${chain.kafka.topic.partitions:2}")
    private int partitions;
    @Value(value="${chain.kafka.topic.replication:1}")
    private short replication;

    protected TopicBuilder initTopicBuilder(String topic) {
        return TopicBuilder.name((String)topic).partitions(this.partitions).replicas((int)this.replication);
    }

    protected NewTopic initTopic(String topic) {
        return this.initTopicBuilder(topic).build();
    }

    protected TopicBuilder initCompactTopicBuilder(String topic) {
        return this.initTopicBuilder(topic).config("cleanup.policy", "compact");
    }

    protected NewTopic initCompactTopic(String topic) {
        return this.initCompactTopicBuilder(topic).build();
    }

    protected TopicBuilder initEventTopicBuilder(String topic) {
        return this.initTopicBuilder(topic).config("cleanup.policy", "delete");
    }

    protected NewTopic initEventTopic(String topic) {
        return this.initEventTopicBuilder(topic).build();
    }
}

