/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import inc.yukawa.chain.kafka.util.KafkaUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.kafka.support.serializer.JsonSerializer;
import reactor.kafka.sender.SenderOptions;

public abstract class KafkaConfigBase {
    @Value(value="${spring.kafka.bootstrap-servers:localhost:9092}")
    protected String bootstrapServers;
    @Value(value="${spring.kafka.state.dir:/tmp/kafka-streams}")
    protected String stateDir;
    @Value(value="${spring.kafka.processing.guarantee:at_least_once}")
    protected String processingGuarantee;
    @Value(value="${spring.kafka.producer.client-id:}")
    protected String clientId = null;
    @Value(value="${spring.kafka.producer.autoflush:true}")
    protected boolean autoFlush = true;

    @Bean
    public ObjectMapper objectMapper() {
        return ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false)).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)).configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Bean(value={"kafka.ProducerProps"})
    public Properties producerProps() {
        return KafkaUtil.producerProps(this.bootstrapServers, this.clientId);
    }

    @Bean(value={"kafka.ProducerConfig"})
    public Map<String, Object> producerConfig() {
        return KafkaUtil.producerConfig(this.bootstrapServers, this.clientId);
    }

    protected <K, V> KafkaProducer<K, V> kafkaProducer() {
        ObjectMapper mapper = this.objectMapper();
        return this.kafkaProducer((Serializer<K>)new JsonSerializer(mapper), (Serializer<V>)new JsonSerializer(mapper), this.producerProps());
    }

    protected <K, V> KafkaProducer<K, V> kafkaProducer(Serializer<K> keySerial, Serializer<V> valueSerial, Properties config) {
        return new KafkaProducer(config, keySerial, valueSerial);
    }

    protected <K, V> ProducerFactory<K, V> producerFactory(Map<String, Object> config, Serializer<K> keySerial, Serializer<V> valueSerial) {
        return new DefaultKafkaProducerFactory(config, keySerial, valueSerial);
    }

    protected <K, V> KafkaTemplate<K, V> kafkaTemplate(Serializer<K> keySerial, Serializer<V> valueSerial) {
        ProducerFactory<K, V> factory = this.producerFactory(this.producerConfig(), keySerial, valueSerial);
        return new KafkaTemplate(factory, this.autoFlush);
    }

    protected <K, V> KafkaTemplate<K, V> kafkaTemplate(Serializer<K> keySerial, Serializer<V> valueSerial, String defaultTopic) {
        KafkaTemplate<K, V> template = this.kafkaTemplate(keySerial, valueSerial);
        template.setDefaultTopic(defaultTopic);
        return template;
    }

    protected ReactiveKafkaProducerTemplate<?, ?> reactiveKafkaTemplate(KafkaProperties properties) {
        SenderOptions options = SenderOptions.create((Map)properties.buildProducerProperties(null));
        return new ReactiveKafkaProducerTemplate(options);
    }

    protected <K, V> ReactiveKafkaProducerTemplate<K, V> reactiveKafkaTemplate(KafkaProperties properties, Serializer<K> keySerial, Serializer<V> valueSerial) {
        SenderOptions options = SenderOptions.create((Map)properties.buildProducerProperties(null)).withKeySerializer(keySerial).withValueSerializer(valueSerial);
        return new ReactiveKafkaProducerTemplate(options);
    }
}

