/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

public class KafkaInitConfigBase<K> {
    private static final Logger log = LoggerFactory.getLogger(KafkaInitConfigBase.class);
    protected final ObjectMapper mapper;
    protected final ReactiveKafkaProducerTemplate<K, Object> template;

    public KafkaInitConfigBase(ObjectMapper mapper, ReactiveKafkaProducerTemplate<K, Object> template) {
        this.mapper = mapper;
        this.template = template;
    }

    protected <R> List<R> parseObject(Resource res, TypeReference<List<R>> typeRef) {
        try {
            List rolesList = (List)this.mapper.readValue(res.getFile(), typeRef);
            log.debug("Read {} values", (Object)rolesList.size());
            return rolesList;
        }
        catch (Exception ex) {
            log.error("{} while mapping a JSON String to {} list", new Object[]{ex.getClass().getSimpleName(), typeRef, ex});
            return Collections.emptyList();
        }
    }

    protected void sendObject(String topic, K key, Object value) {
        this.template.send(topic, key, value).doOnNext(r -> log.debug("[{}] sent: key={}, valueSize={}bytes", new Object[]{r.recordMetadata(), key, r.recordMetadata().serializedValueSize()})).doOnError(e -> log.error("Send failed for: " + String.valueOf(key), e)).block();
    }
}

