/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.config;

import inc.yukawa.chain.base.core.domain.info.HostStoreInfo;
import inc.yukawa.chain.kafka.config.KafkaConfigBase;
import inc.yukawa.chain.kafka.util.StreamUtil;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.kafka.support.serializer.JsonSerde;

public abstract class KafkaStreamsConfigBase
extends KafkaConfigBase {
    @Value(value="${spring.kafka.streams.offset.rest:earliest}")
    protected String offsetRest = "earliest";
    @Value(value="${spring.kafka.streams.application-id}")
    protected String appId = null;

    @Bean
    @Lazy
    public RocksDBConfigSetter getRocksDBConfig() {
        return new StreamUtil.CustomRocksDBConfig();
    }

    @Bean
    public HostStoreInfo hostInfo(@Value(value="${server.host:auto}") String host, @Value(value="${server.port:3333}") int port, @Value(value="${server.servlet.context-path}") String ctxp) {
        return new HostStoreInfo(StreamUtil.initHostAddress(host), port, ctxp);
    }

    protected Properties baseStreamsProps() {
        Properties props = StreamUtil.baseStreamsProps(this.bootstrapServers, this.stateDir, this.appId, this.processingGuarantee);
        props.put("auto.offset.reset", this.offsetRest);
        props.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        props.put("default.production.exception.handler", DefaultProductionExceptionHandler.class);
        props.put("default.key.serde", Serdes.String().getClass());
        props.put(StreamsConfig.consumerPrefix((String)"session.timeout.ms"), (Object)10000);
        props.put("default.value.serde", JsonSerde.class);
        props.put(StreamsConfig.consumerPrefix((String)"session.timeout.ms"), (Object)10000);
        props.put("application.id", this.appId);
        return props;
    }
}

