/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.sender.SenderOptions;

public abstract class ReactiveKafkaConfigBase {
    protected final Logger log = LoggerFactory.getLogger(ReactiveKafkaConfigBase.class);

    @Bean(value={"chain.jsonReactiveKafkaProducerTemplate"})
    public ReactiveKafkaProducerTemplate<String, Object> jsonReactiveKafkaProducerTemplate(KafkaProperties properties, ObjectMapper mapper) {
        return this.defaultReactiveKafkaTemplate(properties, (Serializer)Serdes.String().serializer(), (Serializer)new JsonSerializer(mapper));
    }

    @Bean(value={"chain.stringReceiverOptions"})
    public ReceiverOptions<String, String> stringReceiverOptions(KafkaProperties kafkaProps) {
        return this.objectReceiverOptions(kafkaProps).withValueDeserializer((Deserializer)new ErrorHandlingDeserializer(Serdes.String().deserializer()));
    }

    @Bean(value={"chain.jsonReceiverOptions"})
    public ReceiverOptions<String, Object> jsonReceiverOptions(KafkaProperties kafkaProps) {
        return this.objectReceiverOptions(kafkaProps);
    }

    protected <T> ReceiverOptions<String, T> jsonReceiverOptions(KafkaProperties kafkaProps, TypeReference<T> typeRef, ObjectMapper mapper) {
        return this.objectReceiverOptions(kafkaProps).withValueDeserializer((Deserializer)new ErrorHandlingDeserializer((Deserializer)new JsonDeserializer(typeRef, mapper, false)));
    }

    protected <T> ReceiverOptions<String, T> jsonReceiverOptions(KafkaProperties kafkaProps, Class<T> clazz, ObjectMapper mapper) {
        return this.objectReceiverOptions(kafkaProps).withValueDeserializer((Deserializer)new ErrorHandlingDeserializer((Deserializer)new JsonDeserializer(clazz, mapper, false)));
    }

    protected <T> ReceiverOptions<String, T> objectReceiverOptions(KafkaProperties kafkaProps) {
        return this.defaultReceiverOptions(kafkaProps).withKeyDeserializer((Deserializer)new ErrorHandlingDeserializer(Serdes.String().deserializer()));
    }

    protected <K, V> ReceiverOptions<K, V> defaultReceiverOptions(KafkaProperties kafkaProps) {
        return ReceiverOptions.create((Map)kafkaProps.buildConsumerProperties(null)).addAssignListener(partitions -> this.log.info("onPartitionsAssigned {}", partitions)).addRevokeListener(partitions -> this.log.info("onPartitionsRevoked {}", partitions));
    }

    protected <K, V> ReactiveKafkaProducerTemplate<K, V> defaultReactiveKafkaTemplate(KafkaProperties kafkaProps, Serializer<K> keySerial, Serializer<V> valueSerial) {
        SenderOptions options = SenderOptions.create((Map)kafkaProps.buildProducerProperties(null)).withKeySerializer(keySerial).withValueSerializer(valueSerial);
        return new ReactiveKafkaProducerTemplate(options);
    }
}

