/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.dao.mono;

import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.kafka.dao.mono.KafkaTemplateDao;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class KafkaAsyncWriteDao<K, V>
extends KafkaTemplateDao<K, V>
implements MonoWriteDao<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAsyncWriteDao.class);

    @Deprecated(forRemoval=true)
    public KafkaAsyncWriteDao(ReactiveKafkaProducerTemplate<K, ? super V> template) {
        this(template, (String)null);
    }

    public KafkaAsyncWriteDao(ReactiveKafkaProducerTemplate<K, ? super V> template, String topic) {
        super(template, topic);
    }

    public KafkaAsyncWriteDao(ReactiveKafkaProducerTemplate<K, ? super V> template, NewTopic topic) {
        this(template, topic.name());
    }

    public Mono<V> put(K key, V value) {
        if (key instanceof String) {
            Assert.hasText((String)((String)key), (String)("string key must have some non whitespace char, but was: '" + String.valueOf(key) + "'"));
        }
        return Mono.just(key).doOnNext(e -> LOG.trace("[{}] about to send: key={}, value={}", new Object[]{this.findTopic(), key, value})).then(this.template.send(this.findTopic(), key, value)).doOnNext(r -> LOG.debug("[{}] sent: key={}, valueSize={}bytes", new Object[]{r.recordMetadata(), key, r.recordMetadata().serializedValueSize()})).doOnError(e -> LOG.error("Send failed for: " + String.valueOf(key), e)).thenReturn(value);
    }

    public Mono<Integer> deleteKey(K key) {
        return Mono.just(key).doOnNext(e -> LOG.trace("[{}] about to delete: key={}", (Object)this.findTopic(), key)).then(this.template.send(this.findTopic(), key, null)).doOnNext(r -> LOG.debug("[{}] delete: key={}", (Object)r.recordMetadata(), key)).doOnError(e -> LOG.error("Delete failed for: " + String.valueOf(key), e)).thenReturn((Object)1);
    }
}

