/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.dao.mono;

import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.kafka.streams.KeyValue;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface KafkaMonoReadDao<K, V, F>
extends MonoReadDao<K, V, F> {
    public Flux<KeyValue<K, V>> findKeyValues(F var1);

    public boolean matches(V var1, F var2);

    default public Mono<Map<K, V>> map(F filter) {
        return this.findKeyValues(filter).collectMap(kv -> kv.key, kv -> kv.value);
    }

    default public Flux<V> find(F filter) {
        return this.findKeyValues(filter).map(kv -> kv.value);
    }

    default public Flux<K> findKeys(F filter) {
        return this.findKeyValues(filter).map(kv -> kv.key);
    }

    default public Predicate<KeyValue<K, V>> asPredicate(F filter) {
        return v -> this.matches(v.value, filter);
    }

    default public boolean matches(String value, String filterExpression) {
        return filterExpression == null || Objects.equals(filterExpression, value);
    }

    default public boolean contains(String value, String substring) {
        return substring == null || value != null && value.contains(substring);
    }

    default public <V> boolean contains(Collection<V> list, V value) {
        return value == null || list != null && list.contains(value);
    }
}

