/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.dao.mono;

import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.kafka.dao.mono.KafkaStreamsDao;
import inc.yukawa.chain.kafka.util.StreamUtil;
import java.util.Properties;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import reactor.core.publisher.Mono;

public abstract class KafkaStoreLoadDao<KEY, VAL>
extends KafkaStreamsDao
implements MonoLoadDao<KEY, VAL> {
    protected final String storeName;

    public KafkaStoreLoadDao(String store, Properties streamProps) {
        super(streamProps);
        this.storeName = store;
    }

    protected ReadOnlyKeyValueStore<KEY, VAL> getKeyValueStore() {
        return (ReadOnlyKeyValueStore)StreamUtil.waitUntilStoreIsQueryable(this.storeName, QueryableStoreTypes.keyValueStore(), this.streams, this.timeout);
    }

    public Mono<VAL> load(KEY key) {
        return Mono.fromSupplier(this::getKeyValueStore).filter(s -> s.get(key) != null).map(s -> s.get(key));
    }
}

