/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.event;

import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.base.core.event.ChainEventBean;
import inc.yukawa.chain.kafka.util.MergingBeanUtilsBean;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Reducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEventHandler<V, E extends ChainEventBean<V>>
implements Reducer<E>,
Aggregator<Object, E, E> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseEventHandler.class);
    protected Map<Class<?>, Function> keyExtractors = new HashMap();
    protected Map<MergingBeanUtilsBean.Strategy, MergingBeanUtilsBean> mergersCache = new ConcurrentHashMap<MergingBeanUtilsBean.Strategy, MergingBeanUtilsBean>();

    public BaseEventHandler() {
    }

    public BaseEventHandler(Map<Class<?>, Function> keyExtractors) {
        this.keyExtractors = keyExtractors;
    }

    public E apply(Object key, E value, E aggregate) {
        return this.apply(aggregate, value);
    }

    public E apply(E orig, E evt) {
        try {
            return this.onEvent(orig, evt);
        }
        catch (Exception e) {
            LOG.error("Error handling event " + String.valueOf(evt) + " against original event. Skipping event... " + String.valueOf(orig), (Throwable)e);
            return orig;
        }
    }

    public E onEvent(E orig, E evt) {
        this.preProcess(evt);
        Object payload = evt.getPayload();
        if (!("CREATE".equals(evt.getName()) || "PUT".equals(evt.getName()) || orig != null && orig.getPayload() != null)) {
            LOG.warn("No such record {}, skipping: {}", payload, evt);
            return orig;
        }
        if (orig != null && orig.getPayload() != null && payload instanceof Organized) {
            String origOrgId = ((Organized)orig.getPayload()).getOrgId();
            String evtOrgId = ((Organized)payload).getOrgId();
            if (origOrgId == null && evtOrgId != null) {
                LOG.error("Illegal orgId provided: {}, expected: {}, skipping {}", new Object[]{evtOrgId, origOrgId, evt});
                return orig;
            }
            if (origOrgId != null && !origOrgId.equals(evtOrgId)) {
                LOG.error("Illegal orgId provided: {}, expected: {}, skipping {}", new Object[]{evtOrgId, origOrgId, evt});
                return orig;
            }
            LOG.trace("OrgId match - provided: {}, expected: {}", (Object)evtOrgId, (Object)origOrgId);
        }
        switch (evt.getName()) {
            case "CREATE": {
                return this.onCreate(orig, evt);
            }
            case "UPDATE": {
                return this.onUpdate(orig, evt);
            }
            case "MERGE": {
                return this.onMerge(orig, evt);
            }
            case "PUT": {
                return this.onPut(orig, evt);
            }
            case "DELETE": {
                return this.onDelete(orig, evt);
            }
            case "COLLECTION_APPEND": {
                return this.onCollectionAppend(orig, evt);
            }
            case "COLLECTION_DELETE": {
                return this.onCollectionUpdate(orig, evt);
            }
            case "COLLECTION_REMOVE": {
                return this.onCollectionRemove(orig, evt);
            }
            case "COLLECTION_PUT": {
                return this.onCollectionPut(orig, evt);
            }
        }
        return this.onCustomEvent(orig, evt);
    }

    protected void preProcess(E evt) {
    }

    protected E onCreate(E orig, E evt) {
        Object payload = evt.getPayload();
        if (orig != null && orig.getPayload() != null) {
            LOG.warn("Record {} already exists, skipping: {}", payload, evt);
            return orig;
        }
        if (payload instanceof Created && payload instanceof Changed) {
            ((Created)payload).setCreated(((Changed)payload).getChange());
        }
        return evt;
    }

    protected E onUpdate(E orig, E evt) {
        if (orig == null || orig.getPayload() == null) {
            LOG.warn("No such record {}, skipping: {}", evt.getPayload(), evt);
            return orig;
        }
        return this.onPut(orig, evt);
    }

    protected E onPut(E orig, E evt) {
        if (orig != null && orig.getPayload() != null) {
            evt.setPayload(this.putMerge(orig.getPayload(), evt.getPayload()));
        } else {
            Object payload = evt.getPayload();
            if (payload instanceof Created && payload instanceof Changed) {
                ((Created)payload).setCreated(((Changed)payload).getChange());
            }
        }
        return evt;
    }

    protected E onMerge(E orig, E evt) {
        if (evt.getPayload() instanceof Created) {
            ((Created)evt.getPayload()).setCreated(null);
        }
        this.mergeProps(evt.getPayload(), orig.getPayload(), MergingBeanUtilsBean.Strategy.PUT);
        return orig;
    }

    protected E onDelete(E orig, E evt) {
        return null;
    }

    protected V putMerge(V origPayload, V evtPayload) {
        if (evtPayload instanceof Created) {
            ((Created)evtPayload).setCreated(((Created)origPayload).getCreated());
        }
        return evtPayload;
    }

    protected E onCollectionAppend(E orig, E evt) {
        this.mergeProps(evt.getPayload(), orig.getPayload(), MergingBeanUtilsBean.Strategy.APPEND);
        return orig;
    }

    protected E onCollectionUpdate(E orig, E evt) {
        this.mergeProps(evt.getPayload(), orig.getPayload(), MergingBeanUtilsBean.Strategy.UPDATE);
        return orig;
    }

    protected E onCollectionRemove(E orig, E evt) {
        this.mergeProps(evt.getPayload(), orig.getPayload(), MergingBeanUtilsBean.Strategy.REMOVE);
        return orig;
    }

    protected E onCollectionPut(E orig, E evt) {
        this.mergeProps(evt.getPayload(), orig.getPayload(), MergingBeanUtilsBean.Strategy.PUT);
        return orig;
    }

    protected E onCustomEvent(E orig, E evt) {
        LOG.warn("Unsupported event {}. Skipping {}", (Object)evt.getName(), evt);
        return orig;
    }

    protected void mergeProps(V source, V dest, MergingBeanUtilsBean.Strategy strategy) {
        MergingBeanUtilsBean merger = this.mergersCache.computeIfAbsent(strategy, s -> new MergingBeanUtilsBean((MergingBeanUtilsBean.Strategy)((Object)s), this.keyExtractors));
        try {
            merger.copyProperties(dest, source);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Merging props error, skipping event...", (Throwable)e);
        }
    }
}

