/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.event;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.HostStoreInfo;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.core.event.ChainEventBean;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class EventBasedRepo<K, V extends Keyed<K>, F, E extends ChainEventBean<V>>
implements CrudRepository<K, V, F> {
    protected final MonoReadDao<K, V, F> readDao;
    protected final MonoWriteDao<K, E> eventDao;
    protected final Supplier<E> eventSupplier;
    protected final Supplier<Mono<String>> callerSupplier;

    public EventBasedRepo(MonoReadDao<K, V, F> readDao, MonoWriteDao<K, E> eventDao, Supplier<E> eventSupplier) {
        this(readDao, eventDao, eventSupplier, null);
    }

    public EventBasedRepo(MonoReadDao<K, V, F> readDao, MonoWriteDao<K, E> eventDao, Supplier<E> eventSupplier, Supplier<Mono<String>> callerSupplier) {
        this.readDao = readDao;
        this.eventDao = eventDao;
        this.eventSupplier = eventSupplier;
        this.callerSupplier = callerSupplier;
    }

    public Mono<V> load(K key) {
        Objects.requireNonNull(key, "key");
        return this.readDao.load(key);
    }

    public Mono<V> read(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.read(filter);
    }

    public Mono<Long> count(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.count(filter);
    }

    public Mono<Map<K, V>> map(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.map(filter);
    }

    public Flux<V> find(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.find(filter);
    }

    public Flux<K> findKeys(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.findKeys(filter);
    }

    public Mono<QueryResult<V>> query(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.query(filter);
    }

    public Mono<E> putEvent(E event) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull((Keyed)event.getPayload(), "value");
        Objects.requireNonNull(((Keyed)event.getPayload()).key(), "value.key");
        if (((Keyed)event.getPayload()).key() instanceof String) {
            Assert.hasText((String)((String)((Keyed)event.getPayload()).key()), (String)("value.key must have some non whitespace char, but was: '" + String.valueOf(((Keyed)event.getPayload()).key()) + "'"));
        }
        return this.withChanged(event).flatMap(e -> this.eventDao.put(((Keyed)e.getPayload()).key(), e));
    }

    public Mono<E> putEvent(String eventName, V value) {
        return this.putEvent(this.eventFor(eventName, value));
    }

    public Mono<V> create(V value) {
        return this.putEvent("CREATE", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> put(V value) {
        return this.putEvent("PUT", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> update(V value) {
        return this.putEvent("UPDATE", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> merge(V value) {
        return this.putEvent("MERGE", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> delete(V value) {
        return this.putEvent("DELETE", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> deleteByKey(K key) {
        Objects.requireNonNull(key, "key");
        return this.eventDao.put(key, this.eventFor("DELETE", null)).then(Mono.empty());
    }

    public Flux<V> deleteByFilter(F filter) {
        return this.find(filter).concatMap(this::delete);
    }

    public Mono<V> mergeCollectionsAppend(V value) {
        return this.putEvent("COLLECTION_APPEND", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> mergeCollectionsPut(V value) {
        return this.putEvent("COLLECTION_PUT", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> mergeCollectionsUpdate(V value) {
        return this.putEvent("COLLECTION_DELETE", value).map(ChainEventBean::getPayload);
    }

    public Mono<V> mergeCollectionsRemove(V value) {
        return this.putEvent("COLLECTION_REMOVE", value).map(ChainEventBean::getPayload);
    }

    protected E eventFor(String operation, V payload) {
        try {
            ChainEventBean evt = (ChainEventBean)this.eventSupplier.get();
            evt.setName(operation);
            evt.setPayload(payload);
            return (E)evt;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Mono<E> withChanged(E evt) {
        if (evt.getPayload() instanceof Changed && this.callerSupplier != null) {
            return this.callerSupplier.get().switchIfEmpty(Mono.just((Object)"anonymous")).map(p -> {
                ((Changed)evt.getPayload()).setChange(new Change(p, new Date()));
                return evt;
            });
        }
        return Mono.just(evt);
    }

    public Flux<HostStoreInfo> meta() {
        return null;
    }
}

