/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.event;

import inc.yukawa.chain.base.core.event.ChainEvent;
import inc.yukawa.chain.base.core.event.EventProducer;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.Assert;

public class KafkaEventProducer<K, V>
implements EventProducer<K, V> {
    private final KafkaTemplate<K, ChainEvent<V>> template;

    public KafkaEventProducer(KafkaTemplate<K, ChainEvent<V>> template) {
        this.template = template;
    }

    public void fireAndForget(ChainEvent<V> event) {
        this.template.sendDefault(event);
    }

    public void fireAndForget(ChainEvent<V> event, K key, String channel) {
        if (key instanceof String) {
            Assert.hasText((String)((String)key), (String)("key must have some non whitespace char, but was: '" + String.valueOf(key) + "'"));
        }
        if (channel != null) {
            this.template.send(channel, key, event);
        } else {
            this.template.sendDefault(key, event);
        }
    }

    public void fireAndForget(ChainEvent<V> event, String channel) {
        this.template.send(channel, event);
    }
}

