/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.rest;

import inc.yukawa.chain.kafka.config.InitConfigBase;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class InitConfigRestBase {
    private static final Logger LOG = LoggerFactory.getLogger(InitConfigRestBase.class);
    private final List<InitConfigBase> configs;

    public InitConfigRestBase(List<InitConfigBase> configs) {
        this.configs = configs;
    }

    @GetMapping(value={"/list"})
    @ResponseBody
    public List<String> listConfigs() {
        LOG.info("[{}] listConfigs", (Object)this.getClass().getSimpleName());
        return this.configs.stream().map(InitConfigBase::getName).collect(Collectors.toList());
    }

    @PostMapping(value={"/all"})
    @ResponseBody
    public void initAll() {
        LOG.info("[{}] initAll: {}", (Object)this.getClass().getSimpleName(), this.configs);
        this.configs.forEach(InitConfigBase::doInit);
    }

    @PostMapping(value={"/{name}"})
    @ResponseBody
    public void initByName(@PathVariable(value="name") String name) {
        LOG.info("[{}] initByName: {}", (Object)this.getClass().getSimpleName(), (Object)name);
        this.configs.stream().filter(c -> name.equalsIgnoreCase(c.getName())).forEach(InitConfigBase::doInit);
    }
}

