/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.kafka.support.serializer.JsonSerde;
import org.springframework.util.StringUtils;

public class KafkaUtil {
    public static Map<String, Object> serialConfig(String trusted) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("spring.json.trusted.packages", trusted);
        return config;
    }

    public static <T> Serde<T> getSerDes(Class<T> cls, boolean isKey, ObjectMapper mapper) {
        return KafkaUtil.configure(new JsonSerde(cls, mapper), isKey);
    }

    public static <T> Serde<T> getSerDes(Class<T> cls, boolean isKey) {
        return KafkaUtil.configure(new JsonSerde(cls), isKey);
    }

    public static <T> Serde<T> getSerDes(Class<T> cls, ObjectMapper mapper) {
        return KafkaUtil.configure(new JsonSerde(cls, mapper), false);
    }

    @Deprecated
    public static <T> Serde<T> getSerDes(Class<T> cls) {
        return KafkaUtil.configure(new JsonSerde(cls), false);
    }

    private static <T> Serde<T> configure(Serde<T> serde, boolean isKey) {
        serde.configure(KafkaUtil.serialConfig("*"), isKey);
        return serde;
    }

    public static Map<String, Object> producerConfig(String bootstrapServers, String clientId) {
        HashMap<String, Object> producerConfig = new HashMap<String, Object>();
        producerConfig.put("bootstrap.servers", bootstrapServers);
        producerConfig.put("enable.idempotence", "true");
        producerConfig.put("retries", String.valueOf(Integer.MAX_VALUE));
        producerConfig.put("acks", "all");
        if (StringUtils.hasText((String)clientId)) {
            producerConfig.put("client.id", clientId);
        }
        return producerConfig;
    }

    public static Properties producerProps(String bootstrapServers, String clientId) {
        Properties producerConfig = new Properties();
        producerConfig.putAll(KafkaUtil.producerConfig(bootstrapServers, clientId));
        return producerConfig;
    }

    public static <K, V> KafkaProducer<K, V> startProducer(String bootstrapServers, String clientId, Serializer<K> keySerial, Serializer<V> valueSerial) {
        return KafkaUtil.startProducer(keySerial, valueSerial, KafkaUtil.producerProps(bootstrapServers, clientId));
    }

    public static <K, V> KafkaProducer<K, V> startProducer(Serializer<K> keySerial, Serializer<V> valueSerial, Properties producerConfig) {
        return new KafkaProducer(producerConfig, keySerial, valueSerial);
    }

    public static Map<String, Object> consumerConfig(String bootstrapServers, String groupId, Boolean autoCommit) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", bootstrapServers);
        if (autoCommit != null) {
            config.put("enable.auto.commit", autoCommit.toString());
        }
        if (StringUtils.hasText((String)groupId)) {
            config.put("group.id", groupId);
        }
        return config;
    }
}

