/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.util;

import inc.yukawa.chain.base.core.domain.info.HostStoreInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.errors.UnknownStateStoreException;

public class MetadataService {
    private final KafkaStreams streams;

    public MetadataService(KafkaStreams streams) {
        this.streams = streams;
    }

    public List<HostStoreInfo> streamsMetadata() {
        Collection metadata = this.streams.metadataForAllStreamsClients();
        return this.mapInstancesToHostStoreInfo(metadata);
    }

    public List<HostStoreInfo> streamsMetadataForStore(String store) {
        Collection metadata = this.streams.streamsMetadataForStore(store);
        return this.mapInstancesToHostStoreInfo(metadata);
    }

    public <K> HostStoreInfo streamsMetadataForStoreAndKey(String store, K key, Serializer<K> serializer) {
        KeyQueryMetadata metadata = this.streams.queryMetadataForKey(store, key, serializer);
        if (metadata == null) {
            throw new UnknownStateStoreException(store + " " + String.valueOf(key));
        }
        return new HostStoreInfo(metadata.activeHost().host(), metadata.activeHost().port(), store);
    }

    private List<HostStoreInfo> mapInstancesToHostStoreInfo(Collection<StreamsMetadata> metaDatas) {
        return metaDatas.stream().map(metadata -> new HostStoreInfo(metadata.host(), metadata.port(), metadata.stateStoreNames())).collect(Collectors.toList());
    }
}

