/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.connect.admin;

import inc.yukawa.chain.base.core.domain.result.AbstractResult;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import inc.yukawa.chain.kafka.connect.admin.ConnectClient;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ConnectAdmin {
    private final ConnectClient connectClient;
    private final Map<String, Map<String, Object>> connectors;

    public ConnectAdmin(ConnectClient connectClient, Map<String, Map<String, Object>> connectors) {
        this.connectClient = connectClient;
        this.connectors = connectors;
    }

    public Flux<String> findConnectorNames() {
        return this.connectClient.findConnectorNames();
    }

    public Flux<Map<String, Object>> findConnectorStatus() {
        return Flux.fromIterable(this.connectors.keySet()).flatMap(this.connectClient::loadConnectorStatus);
    }

    public Flux<Map<String, Object>> findConnectors() {
        return Flux.fromIterable(this.connectors.keySet()).flatMap(this.connectClient::loadConnector);
    }

    public Mono<EditResult> deleteConnectors() {
        return Flux.fromIterable(this.connectors.entrySet()).flatMap(entry -> this.connectClient.deleteConnector((String)entry.getKey())).map(editResult -> {
            ResultDetail error = editResult.findError();
            return Objects.requireNonNullElseGet(error, () -> ResultDetail.info((String)("Deleted " + editResult.getKey()), (String)"DELETE", (String)editResult.getKey()));
        }).collectList().map(details -> {
            EditResult result = new EditResult("deleteConnectors", String.class);
            result.setKey("" + details.size());
            result.addMessages((Collection)details);
            return result;
        });
    }

    public Mono<EditResult> createConnectors() {
        return Flux.fromIterable(this.connectors.entrySet()).flatMap(entry -> this.connectClient.createConnector((String)entry.getKey(), (Map)entry.getValue())).map(editResult -> {
            ResultDetail error = editResult.findError();
            return Objects.requireNonNullElseGet(error, () -> ResultDetail.info((String)("Created " + editResult.getKey()), (String)"OK", (String)editResult.getKey()));
        }).collectList().map(details -> {
            EditResult result = new EditResult("createConnectors", String.class);
            result.setKey("" + details.size());
            result.addMessages((Collection)details);
            return result;
        });
    }

    public Mono<EditResult> initConnectors(boolean delete) {
        long started = System.currentTimeMillis();
        Mono deleteResult = delete ? this.deleteConnectors() : Mono.just((Object)new EditResult());
        return deleteResult.zipWith(this.createConnectors()).map(zip -> {
            EditResult initResult = new EditResult("initConnectors", String.class);
            initResult.merge((AbstractResult)zip.getT1());
            initResult.merge((AbstractResult)zip.getT2());
            initResult.setKey(((EditResult)zip.getT2()).getKey());
            initResult.setTook(Long.valueOf(System.currentTimeMillis() - started));
            return initResult;
        });
    }

    public Mono<EditResult> customConnector(Map<String, Object> config) {
        String name = (String)config.get("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Connector name not specified");
        }
        return this.connectClient.createConnector(name, config);
    }
}

