/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.connect.admin;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.kafka.connect.admin.ConnectAdmin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Tag(name="ConnectAdmin")
@RequestMapping(value={"/admin/connectors"}, produces={"application/json", "text/xml"})
public class ConnectAdminRest {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectAdminRest.class);
    private final ConnectAdmin connectAdmin;
    private static final String SAMPLE_CONNECTOR_CONFIG = "{\n      \"connector.class\": \"io.confluent.connect.elasticsearch.ElasticsearchSinkConnector\",\n      \"type.name\": \"_doc\",\n      \"errors.log.include.messages\": \"true\",\n      \"behavior.on.null.values\": \"delete\",\n      \"topics\": \"\",\n      \"tasks.max\": \"2\",\n      \"connection.timeout.ms\": \"5000\",\n      \"max.retries\": \"100000\",\n      \"key.ignore\": \"false\",\n      \"topics.regex\": \"chain-.*-data\",\n      \"schema.ignore\": \"true\",\n      \"behavior.on.malformed.documents\": \"warn\",\n      \"key.converter.schemas.enable\": \"false\",\n      \"name\": \"chain-elastic-data\",\n      \"value.converter.schemas.enable\": \"false\",\n      \"connection.url\": \"http://elastic:9200\",\n      \"value.converter\": \"org.apache.kafka.connect.json.JsonConverter\",\n      \"errors.log.enable\": \"false\",\n      \"read.timeout.ms\": \"10000\"\n    }";

    public ConnectAdminRest(ConnectAdmin connectAdmin) {
        this.connectAdmin = connectAdmin;
    }

    @GetMapping
    @Operation(summary="findConnectors", description="find connectors")
    public Flux<Map<String, Object>> findConnectors() {
        return this.connectAdmin.findConnectors();
    }

    @GetMapping(value={"name"})
    @Operation(summary="findConnectorNames", description="find connector names")
    public Flux<String> findConnectorNames() {
        return this.connectAdmin.findConnectorNames();
    }

    @GetMapping(value={"status"})
    @Operation(summary="findConnectorStatus", description="find connector status")
    public Flux<Map<String, Object>> findConnectorStatus() {
        return this.connectAdmin.findConnectorStatus();
    }

    @PostMapping
    @Operation(summary="initConnectors", description="setup connector(s)")
    public Mono<EditResult> initConnectors(@RequestParam(value="deleteConnectors", defaultValue="true") boolean deleteConnectors) {
        LOG.debug("initElasticConnector with deleteConnectors={}", (Object)deleteConnectors);
        return this.connectAdmin.initConnectors(deleteConnectors);
    }

    @DeleteMapping
    @Operation(summary="deleteConnectors", description="delete connectors")
    public Mono<EditResult> deleteConnectors() {
        LOG.debug("deleteElasticConnectors");
        return this.connectAdmin.deleteConnectors();
    }

    @PostMapping(value={"/custom"})
    @Operation(summary="customConnector", description="create custom connector")
    public Mono<EditResult> customConnector(@RequestBody @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\n      \"connector.class\": \"io.confluent.connect.elasticsearch.ElasticsearchSinkConnector\",\n      \"type.name\": \"_doc\",\n      \"errors.log.include.messages\": \"true\",\n      \"behavior.on.null.values\": \"delete\",\n      \"topics\": \"\",\n      \"tasks.max\": \"2\",\n      \"connection.timeout.ms\": \"5000\",\n      \"max.retries\": \"100000\",\n      \"key.ignore\": \"false\",\n      \"topics.regex\": \"chain-.*-data\",\n      \"schema.ignore\": \"true\",\n      \"behavior.on.malformed.documents\": \"warn\",\n      \"key.converter.schemas.enable\": \"false\",\n      \"name\": \"chain-elastic-data\",\n      \"value.converter.schemas.enable\": \"false\",\n      \"connection.url\": \"http://elastic:9200\",\n      \"value.converter\": \"org.apache.kafka.connect.json.JsonConverter\",\n      \"errors.log.enable\": \"false\",\n      \"read.timeout.ms\": \"10000\"\n    }")})}) Map<String, Object> config) {
        LOG.debug("initElasticConnector with customConnector config={}", config);
        return this.connectAdmin.customConnector(config);
    }
}

