/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.kafka.connect.admin;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.kafka.connect.admin.ConnectClient;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Tag(name="ConnectClientRest")
@RequestMapping(value={"/admin/kafka/connectors"}, produces={"application/json", "text/xml"})
public class ConnectClientRest {
    private final ConnectClient connectClient;

    public ConnectClientRest(ConnectClient connectClient) {
        this.connectClient = connectClient;
    }

    @GetMapping(path={"{name}"})
    @Operation(summary="loadConnector", description="load connector")
    public Mono<Map<String, Object>> loadConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.loadConnector(name);
    }

    @GetMapping(path={"{name}/config"})
    @Operation(summary="loadConnectorConfig", description="load connector config")
    public Mono<Map<String, Object>> loadConnectorConfig(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.loadConnectorConfig(name);
    }

    @GetMapping(path={"{name}/status"})
    @Operation(summary="loadConnectorStatus", description="load connector status")
    public Mono<Map<String, Object>> loadConnectorStatus(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.loadConnectorStatus(name);
    }

    @GetMapping(path={"{name}/tasks"})
    @Operation(summary="findConnectorTasks", description="find connector tasks")
    public Flux<Map<String, Object>> findConnectorTasks(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.findConnectorTasks(name);
    }

    @PostMapping(path={"{name}"})
    @Operation(summary="createConnector", description="create connector")
    public Mono<EditResult> createConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name, @RequestBody Map<String, Object> config) {
        return this.connectClient.createConnector(name, config);
    }

    @PutMapping(path={"{name}"})
    @Operation(summary="updateConnector", description="update connector")
    public Mono<EditResult> updateConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name, @RequestBody Map<String, Object> config) {
        return this.connectClient.updateConnector(name, config);
    }

    @PutMapping(path={"{name}/pause"})
    @Operation(summary="pauseConnector", description="pause connector")
    public Mono<EditResult> pauseConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.pauseConnector(name);
    }

    @PutMapping(path={"{name}/resume"})
    @Operation(summary="resumeConnector", description="resume connector")
    public Mono<EditResult> resumeConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.resumeConnector(name);
    }

    @PutMapping(path={"{name}/restart"})
    @Operation(summary="restartConnector", description="restart connector")
    public Mono<EditResult> restartConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.resumeConnector(name);
    }

    @DeleteMapping(path={"{name}"})
    @Operation(summary="deleteConnector", description="delete connector")
    public Mono<EditResult> deleteConnector(@PathVariable(value="name") @Parameter(example="chain-console-elastic-data") String name) {
        return this.connectClient.deleteConnector(name);
    }
}

