/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"push-token-aspect", "all-aspects", "default"})
public class FirebaseConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FirebaseConfig.class);
    @Value(value="${chain.main.firebase.enabled}")
    private boolean enabled;
    @Value(value="${chain.main.firebase.serviceAccount.type}")
    private String serviceAccountType;
    @Value(value="${chain.main.firebase.serviceAccount.projectId}")
    private String serviceAccountProjectId;
    @Value(value="${chain.main.firebase.serviceAccount.privateKeyId}")
    private String serviceAccountPrivateKeyId;
    @Value(value="${chain.main.firebase.serviceAccount.privateKey}")
    private String serviceAccountPrivateKey;
    @Value(value="${chain.main.firebase.serviceAccount.clientEmail}")
    private String serviceAccountClientEmail;
    @Value(value="${chain.main.firebase.serviceAccount.clientId}")
    private String serviceAccountClientId;
    @Value(value="${chain.main.firebase.serviceAccount.authUri}")
    private String serviceAccountAuthUri;
    @Value(value="${chain.main.firebase.serviceAccount.tokenUri}")
    private String serviceAccountTokenUri;
    @Value(value="${chain.main.firebase.serviceAccount.authProviderX509CertUrl}")
    private String serviceAccountAuthProviderX509CertUrl;
    @Value(value="${chain.main.firebase.serviceAccount.clientX509CertUrl}")
    private String serviceAccountClientX509CertUrl;

    @Bean
    public FirebaseMessaging firebaseMessaging(ObjectMapper objectMapper) throws IOException {
        if (!this.enabled) {
            LOG.info("Firebase integration is disabled");
            return null;
        }
        GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)this.prepareAccessConfig(objectMapper));
        FirebaseOptions firebaseOptions = FirebaseOptions.builder().setCredentials(googleCredentials).build();
        FirebaseApp app = FirebaseApp.initializeApp((FirebaseOptions)firebaseOptions);
        return FirebaseMessaging.getInstance((FirebaseApp)app);
    }

    private InputStream prepareAccessConfig(ObjectMapper objectMapper) throws JsonProcessingException {
        HashMap<String, String> serviceAccount = new HashMap<String, String>();
        serviceAccount.put("type", this.serviceAccountType);
        serviceAccount.put("project_id", this.serviceAccountProjectId);
        serviceAccount.put("private_key_id", this.serviceAccountPrivateKeyId);
        serviceAccount.put("private_key", this.serviceAccountPrivateKey);
        serviceAccount.put("client_email", this.serviceAccountClientEmail);
        serviceAccount.put("client_id", this.serviceAccountClientId);
        serviceAccount.put("auth_uri", this.serviceAccountAuthUri);
        serviceAccount.put("token_uri", this.serviceAccountTokenUri);
        serviceAccount.put("auth_provider_x509_cert_url", this.serviceAccountAuthProviderX509CertUrl);
        serviceAccount.put("client_x509_cert_url", this.serviceAccountClientX509CertUrl);
        return new ByteArrayInputStream(objectMapper.writeValueAsBytes(serviceAccount));
    }
}

