/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config;

import inc.yukawa.chain.modules.main.service.notification.RestSmsSender;
import io.netty.handler.logging.LogLevel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import org.thymeleaf.TemplateEngine;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.logging.AdvancedByteBufFormat;

@Configuration
@ConditionalOnProperty(prefix="chain.main.sms", name={"provider"}, havingValue="rest")
@Profile(value={"notification-aspect", "all-aspects", "default"})
public class RestSmsSenderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RestSmsSenderConfig.class);
    @Value(value="${chain.main.sms.rest.enabled:false}")
    private boolean enabled;
    @Value(value="${chain.main.sms.rest.apiBaseUrl}")
    public String apiBaseUrl;
    @Value(value="${chain.main.sms.rest.authToken}")
    public String authToken;
    @Value(value="${chain.main.sms.rest.sendPath:}")
    private String sendPath;
    @Value(value="${chain.main.sms.rest.sendHttpMethod:POST}")
    private String sendHttpMethod;
    @Value(value="${chain.main.sms.rest.sendSmsRequestBodyTemplateName:sendSmsRequestBodyTemplate}")
    private String sendSmsRequestBodyTemplateName;

    @Bean
    public RestSmsSender restSmsSender(TemplateEngine templateEngine) {
        if (!this.enabled) {
            LOG.info("REST SMS integration is disabled");
            return null;
        }
        LOG.info("REST SMS integration is enabled");
        RestSmsSender sender = new RestSmsSender(this.restSmsSenderWebClient(), templateEngine);
        sender.setSendHttpMethod(this.sendHttpMethod);
        sender.setSendPath(this.sendPath);
        sender.setSendSmsRequestBodyTemplateName(this.sendSmsRequestBodyTemplateName);
        return sender;
    }

    private WebClient restSmsSenderWebClient() {
        HttpClient httpClient = (HttpClient)HttpClient.create().wiretap("reactor.netty.http.client.HttpClient", LogLevel.DEBUG, AdvancedByteBufFormat.TEXTUAL);
        return WebClient.builder().baseUrl(this.apiBaseUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).defaultHeaders(header -> header.setBearerAuth(this.authToken)).defaultHeaders(header -> header.setContentType(MediaType.APPLICATION_JSON)).defaultHeaders(header -> header.setAccept(List.of(MediaType.APPLICATION_JSON))).build();
    }
}

