/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config;

import inc.yukawa.chain.modules.main.service.notification.SmppSmsSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.BindParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@ConditionalOnProperty(prefix="chain.main.sms", name={"provider"}, havingValue="smpp")
@Profile(value={"notification-aspect", "all-aspects", "default"})
public class SmppSmsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SmppSmsConfig.class);
    @Value(value="${chain.main.sms.smpp.enabled:false}")
    private boolean enabled;
    @Value(value="${chain.main.sms.smpp.bind.bindType:BIND_TX}")
    private BindType bindType;
    @Value(value="${chain.main.sms.smpp.bind.systemId:#{null}}")
    private String systemId;
    @Value(value="${chain.main.sms.smpp.bind.password:#{null}}")
    private String password;
    @Value(value="${chain.main.sms.smpp.bind.systemType:#{null}}")
    private String systemType;
    @Value(value="${chain.main.sms.smpp.bind.addrTon:UNKNOWN}")
    private TypeOfNumber addrTon;
    @Value(value="${chain.main.sms.smpp.bind.addrNpi:UNKNOWN}")
    private NumberingPlanIndicator addrNpi;
    @Value(value="${chain.main.sms.smpp.bind.addressRange:#{null}}")
    private String addressRange;
    @Value(value="${chain.main.sms.smpp.bind.interfaceVersion:IF_50}")
    private InterfaceVersion interfaceVersion;

    @Bean
    public SmppSmsSender smppClientService() {
        if (!this.enabled) {
            LOG.info("SMPP SMS integration is disabled");
            return null;
        }
        return new SmppSmsSender(this.bindParameter());
    }

    private BindParameter bindParameter() {
        return new BindParameter(this.bindType, this.systemId, this.password, this.systemType, this.addrTon, this.addrNpi, this.addressRange, this.interfaceVersion);
    }
}

